/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import java.util.List;
import java.util.stream.Collectors;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.config.SoulConfig;
import org.dromara.soul.web.configuration.DubboConfiguration;
import org.dromara.soul.web.configuration.ErrorHandlerConfiguration;
import org.dromara.soul.web.configuration.LocalCacheConfiguration;
import org.dromara.soul.web.disruptor.publisher.SoulEventPublisher;
import org.dromara.soul.web.filter.BodyWebFilter;
import org.dromara.soul.web.filter.ParamWebFilter;
import org.dromara.soul.web.filter.TimeWebFilter;
import org.dromara.soul.web.filter.WebSocketWebFilter;
import org.dromara.soul.web.handler.SoulWebHandler;
import org.dromara.soul.web.influxdb.service.InfluxDbService;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.after.MonitorPlugin;
import org.dromara.soul.web.plugin.after.ResponsePlugin;
import org.dromara.soul.web.plugin.before.GlobalPlugin;
import org.dromara.soul.web.plugin.before.SignPlugin;
import org.dromara.soul.web.plugin.before.WafPlugin;
import org.dromara.soul.web.plugin.function.DividePlugin;
import org.dromara.soul.web.plugin.function.RateLimiterPlugin;
import org.dromara.soul.web.plugin.function.RewritePlugin;
import org.dromara.soul.web.plugin.function.WebSocketPlugin;
import org.dromara.soul.web.plugin.ratelimter.RedisRateLimiter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.server.WebFilter;

@Configuration
@ComponentScan(value={"org.dromara.soul"})
@Import(value={DubboConfiguration.class, LocalCacheConfiguration.class, ErrorHandlerConfiguration.class})
public class SoulConfiguration {
    private final LocalCacheManager localCacheManager;
    private final UpstreamCacheManager upstreamCacheManager;

    @Autowired(required=false)
    public SoulConfiguration(LocalCacheManager localCacheManager, UpstreamCacheManager upstreamCacheManager) {
        this.localCacheManager = localCacheManager;
        this.upstreamCacheManager = upstreamCacheManager;
    }

    @Bean
    public SoulPlugin globalPlugin() {
        return new GlobalPlugin();
    }

    @Bean
    public SoulPlugin signPlugin() {
        return new SignPlugin(this.localCacheManager);
    }

    @Bean
    public SoulPlugin wafPlugin() {
        return new WafPlugin(this.localCacheManager);
    }

    @Bean
    public SoulPlugin rateLimiterPlugin() {
        return new RateLimiterPlugin(this.localCacheManager, this.redisRateLimiter());
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisRateLimiter redisRateLimiter() {
        return new RedisRateLimiter();
    }

    @Bean
    public SoulPlugin rewritePlugin() {
        return new RewritePlugin(this.localCacheManager);
    }

    @Bean
    public SoulPlugin dividePlugin() {
        return new DividePlugin(this.localCacheManager, this.upstreamCacheManager);
    }

    @Bean
    public WebSocketPlugin webSocketPlugin(WebSocketClient webSocketClient, WebSocketService webSocketService) {
        return new WebSocketPlugin(this.localCacheManager, this.upstreamCacheManager, webSocketClient, webSocketService);
    }

    @Bean
    public InfluxDbService influxDbService() {
        return new InfluxDbService();
    }

    @Bean
    public SoulEventPublisher soulEventPublisher(InfluxDbService influxDbService) {
        return new SoulEventPublisher(influxDbService);
    }

    @Bean
    public SoulPlugin monitorPlugin(SoulEventPublisher soulEventPublisher) {
        return new MonitorPlugin(soulEventPublisher, this.localCacheManager);
    }

    @Bean
    public SoulPlugin responsePlugin() {
        return new ResponsePlugin();
    }

    @Bean(value={"webHandler"})
    public SoulWebHandler soulWebHandler(List<SoulPlugin> plugins) {
        List<SoulPlugin> soulPlugins = plugins.stream().sorted((m, n) -> {
            if (m.pluginType().equals((Object)n.pluginType())) {
                return m.getOrder() - n.getOrder();
            }
            return m.pluginType().getName().compareTo(n.pluginType().getName());
        }).collect(Collectors.toList());
        return new SoulWebHandler(soulPlugins);
    }

    @Bean
    @Order(value=-1)
    public WebFilter bodyWebFilter() {
        return new BodyWebFilter();
    }

    @Bean
    @Order(value=1)
    public WebFilter paramWebFilter() {
        return new ParamWebFilter();
    }

    @Bean
    @Order(value=2)
    @ConditionalOnProperty(name={"soul.filterTimeEnable"}, matchIfMissing=true)
    public WebFilter timeWebFilter(SoulConfig soulConfig) {
        return new TimeWebFilter(soulConfig);
    }

    @Bean
    @Order(value=2)
    public WebFilter webSocketWebFilter() {
        return new WebSocketWebFilter();
    }

    @Bean
    public ReactorNettyWebSocketClient reactorNettyWebSocketClient() {
        return new ReactorNettyWebSocketClient();
    }

    @Bean
    public WebSocketService webSocketService() {
        return new HandshakeWebSocketService();
    }
}

