/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.DateUtils;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.config.SoulConfig;
import org.dromara.soul.web.filter.AbstractWebFilter;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class TimeWebFilter
extends AbstractWebFilter {
    private SoulConfig soulConfig;

    public TimeWebFilter(SoulConfig soulConfig) {
        this.soulConfig = soulConfig;
    }

    @Override
    protected Mono<Boolean> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        LocalDateTime now;
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        if (Objects.isNull(requestDTO) || StringUtils.isBlank((CharSequence)requestDTO.getTimestamp())) {
            return Mono.just((Object)false);
        }
        LocalDateTime start = DateUtils.parseLocalDateTime((String)requestDTO.getTimestamp());
        long between = DateUtils.acquireMinutesBetween((LocalDateTime)start, (LocalDateTime)(now = LocalDateTime.now()));
        if (between < (long)this.soulConfig.getFilterTime().intValue()) {
            return Mono.just((Object)true);
        }
        return Mono.just((Object)false);
    }

    @Override
    protected Mono<Void> doDenyResponse(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.REQUEST_TIMEOUT);
        SoulResult result = SoulResult.error((String)"timestamp is not passed validation");
        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(GsonUtils.getInstance().toJson((Object)result).getBytes())));
    }
}

