/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.handler;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.reactive.error.DefaultErrorWebExceptionHandler;
import org.springframework.boot.web.reactive.error.ErrorAttributes;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;

public class GlobalErrorHandler
extends DefaultErrorWebExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalErrorHandler.class);

    public GlobalErrorHandler(ErrorAttributes errorAttributes, ResourceProperties resourceProperties, ErrorProperties errorProperties, ApplicationContext applicationContext) {
        super(errorAttributes, resourceProperties, errorProperties, applicationContext);
    }

    protected Map<String, Object> getErrorAttributes(ServerRequest request, boolean includeStackTrace) {
        this.logError(request);
        return GlobalErrorHandler.response(HttpStatus.INTERNAL_SERVER_ERROR.value());
    }

    protected RouterFunction<ServerResponse> getRoutingFunction(ErrorAttributes errorAttributes) {
        return RouterFunctions.route((RequestPredicate)RequestPredicates.all(), arg_0 -> ((GlobalErrorHandler)this).renderErrorResponse(arg_0));
    }

    protected HttpStatus getHttpStatus(Map<String, Object> errorAttributes) {
        int statusCode = (Integer)errorAttributes.get("code");
        return HttpStatus.valueOf((int)statusCode);
    }

    private static Map<String, Object> response(int status) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("code", status);
        map.put("message", "soul have some exception!");
        map.put("data", null);
        return map;
    }

    private void logError(ServerRequest request) {
        Throwable ex = this.getError(request);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(request.exchange().getLogPrefix() + this.formatError(ex, request));
        }
    }

    private String formatError(Throwable ex, ServerRequest request) {
        String reason = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        return "Resolved [" + reason + "] for HTTP " + request.methodName() + " " + request.path();
    }
}

