/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.SelectorTypeEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.condition.strategy.MatchStrategyFactory;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractSoulPlugin
implements SoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSoulPlugin.class);
    private final LocalCacheManager localCacheManager;

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, SoulPluginChain var2, SelectorData var3, RuleData var4);

    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        PluginData pluginData = this.localCacheManager.findPluginByName(this.named());
        if (!this.skip(exchange).booleanValue() && pluginData != null && pluginData.getEnabled().booleanValue()) {
            List<RuleData> rules;
            List<SelectorData> selectors = this.localCacheManager.findSelectorByPluginName(this.named());
            if (CollectionUtils.isEmpty(selectors)) {
                return chain.execute(exchange);
            }
            SelectorData selectorData = selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, exchange) != false).findFirst().orElse(null);
            if (Objects.isNull(selectorData)) {
                return chain.execute(exchange);
            }
            if (selectorData.getLoged().booleanValue()) {
                LogUtils.info((Logger)LOGGER, (String)(this.named() + " selector success selector name :{}"), () -> ((SelectorData)selectorData).getName());
            }
            if (CollectionUtils.isEmpty(rules = this.localCacheManager.findRuleBySelectorId(selectorData.getId()))) {
                return chain.execute(exchange);
            }
            RuleData rule = this.filterRule(exchange, rules);
            RequestDTO request = (RequestDTO)exchange.getAttribute("requestDTO");
            if (Objects.isNull(rule)) {
                if (PluginEnum.DIVIDE.getName().equals(this.named()) || PluginEnum.DUBBO.getName().equals(this.named()) || PluginEnum.SPRING_CLOUD.getName().equals(this.named())) {
                    LogUtils.info((Logger)LOGGER, () -> Objects.requireNonNull(request).getModule() + ":" + request.getMethod() + " not match  " + this.named() + "  rule");
                    SoulResult error = SoulResult.error((int)HttpStatus.NOT_FOUND.value(), (String)"this can not rule upstream please check you configuration!");
                    return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)error)).getBytes())));
                }
                return chain.execute(exchange);
            }
            if (rule.getLoged().booleanValue()) {
                LogUtils.info((Logger)LOGGER, () -> Objects.requireNonNull(request).getModule() + ":" + request.getMethod() + " match " + this.named() + " rule is name :" + rule.getName());
            }
            return this.doExecute(exchange, chain, selectorData, rule);
        }
        return chain.execute(exchange);
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyFactory.of(selector.getMatchMode()).match(selector.getConditionList(), exchange);
        }
        return true;
    }

    private RuleData filterRule(ServerWebExchange exchange, List<RuleData> rules) {
        return rules.stream().filter(rule -> Objects.nonNull(rule) && rule.getEnabled() != false).filter(ruleData -> MatchStrategyFactory.of(ruleData.getMatchMode()).match(ruleData.getConditionDataList(), exchange)).findFirst().orElse(null);
    }

    public AbstractSoulPlugin(LocalCacheManager localCacheManager) {
        this.localCacheManager = localCacheManager;
    }
}

