/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.after;

import java.util.Objects;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class ResponsePlugin
implements SoulPlugin {
    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            ServerHttpResponse response = exchange.getResponse();
            RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
            assert (requestDTO != null);
            if (requestDTO.getRpcType().equals(RpcTypeEnum.DUBBO.getName())) {
                Object result = exchange.getAttribute("dubbo_rpc_result");
                try {
                    if (Objects.isNull(result)) {
                        return response.writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)SoulResult.error((String)"dubbo rpc have error or fuse ing please check your param and  try again later"))).getBytes())));
                    }
                    return response.writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.dubboResultJson((Object)result)).getBytes())));
                }
                catch (SoulException e) {
                    return Mono.empty();
                }
            }
            ClientResponse clientResponse = (ClientResponse)exchange.getAttribute("webHandlerClientResponse");
            if (Objects.isNull(clientResponse) || response.getStatusCode() == HttpStatus.BAD_GATEWAY || response.getStatusCode() == HttpStatus.INTERNAL_SERVER_ERROR) {
                String result = JsonUtils.toJson((Object)SoulResult.error((String)"this is bad request or fuse ing please try again later"));
                return response.writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(result).getBytes())));
            }
            if (response.getStatusCode() == HttpStatus.GATEWAY_TIMEOUT) {
                String result = JsonUtils.toJson((Object)SoulResult.timeout((String)"this request is time out  Please try again later"));
                return response.writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(result).getBytes())));
            }
            return response.writeWith((Publisher)clientResponse.body(BodyExtractors.toDataBuffers()));
        }));
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.LAST;
    }

    @Override
    public int getOrder() {
        return PluginEnum.RESPONSE.getCode();
    }

    @Override
    public String named() {
        return PluginEnum.RESPONSE.getName();
    }
}

