/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.before;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.result.SoulResult;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.common.utils.SignUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SignPlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignPlugin.class);
    private LocalCacheManager localCacheManager;

    public SignPlugin(LocalCacheManager localCacheManager) {
        super(localCacheManager);
        this.localCacheManager = localCacheManager;
    }

    @Override
    public String named() {
        return PluginEnum.SIGN.getName();
    }

    @Override
    public int getOrder() {
        return PluginEnum.SIGN.getCode();
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        Boolean success = this.signVerify(Objects.requireNonNull(requestDTO));
        if (!success.booleanValue()) {
            exchange.getResponse().setStatusCode(HttpStatus.UNAUTHORIZED);
            SoulResult error = SoulResult.error((int)HttpStatus.UNAUTHORIZED.value(), (String)"sign is not pass,Please check you sign algorithm!");
            return exchange.getResponse().writeWith((Publisher)Mono.just((Object)exchange.getResponse().bufferFactory().wrap(Objects.requireNonNull(JsonUtils.toJson((Object)error)).getBytes())));
        }
        return chain.execute(exchange);
    }

    private Boolean signVerify(RequestDTO requestDTO) {
        if (StringUtils.isBlank((CharSequence)requestDTO.getAppKey())) {
            LogUtils.error((Logger)LOGGER, () -> " app key can not incoming!");
            return false;
        }
        AppAuthData appAuthData = this.localCacheManager.findAuthDataByAppKey(requestDTO.getAppKey());
        if (Objects.isNull(appAuthData) || StringUtils.isBlank((CharSequence)requestDTO.getSign()) || StringUtils.isBlank((CharSequence)requestDTO.getAppKey()) || StringUtils.isBlank((CharSequence)appAuthData.getAppKey()) || StringUtils.isBlank((CharSequence)appAuthData.getAppSecret()) || !appAuthData.getEnabled().booleanValue()) {
            LogUtils.error((Logger)LOGGER, () -> requestDTO.getAppKey() + " can not configuration!");
            return false;
        }
        return SignUtils.getInstance().isValid(requestDTO.getSign(), this.buildParamsMap(requestDTO), appAuthData.getAppSecret());
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.BEFORE;
    }

    private Map<String, String> buildParamsMap(RequestDTO dto) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        map.put("timestamp", dto.getTimestamp());
        map.put("module", dto.getModule());
        map.put("method", dto.getMethod());
        map.put("rpcType", dto.getRpcType());
        return map;
    }
}

