/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.config;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dromara.soul.common.config.MonitorConfig;
import org.dromara.soul.common.config.RateLimiterConfig;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RedisModeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.plugin.config.Singleton;
import org.springframework.data.influxdb.InfluxDBConnectionFactory;
import org.springframework.data.influxdb.InfluxDBProperties;
import org.springframework.data.influxdb.InfluxDBTemplate;
import org.springframework.data.influxdb.converter.PointCollectionConverter;
import org.springframework.data.influxdb.converter.PointConverter;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class PluginConfigHandler
extends Enum<PluginConfigHandler> {
    public static final /* enum */ PluginConfigHandler INS = new PluginConfigHandler();
    private static final /* synthetic */ PluginConfigHandler[] $VALUES;

    public static PluginConfigHandler[] values() {
        return (PluginConfigHandler[])$VALUES.clone();
    }

    public static PluginConfigHandler valueOf(String name) {
        return Enum.valueOf(PluginConfigHandler.class, name);
    }

    public void initPluginConfig(List<PluginData> pluginDataList) {
        pluginDataList.stream().filter(PluginData::getEnabled).forEach(pluginData -> {
            if (PluginEnum.MONITOR.getName().equals(pluginData.getName())) {
                MonitorConfig monitorConfig = (MonitorConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), MonitorConfig.class);
                if (Objects.isNull(Singleton.INST.get(InfluxDBTemplate.class)) || Objects.isNull(Singleton.INST.get(MonitorConfig.class)) || !monitorConfig.equals((Object)Singleton.INST.get(MonitorConfig.class))) {
                    InfluxDBConnectionFactory connectionFactory = new InfluxDBConnectionFactory(this.buildByConfig(monitorConfig));
                    InfluxDBTemplate influxDBTemplate = new InfluxDBTemplate(connectionFactory, (PointCollectionConverter)new PointConverter());
                    Singleton.INST.single(InfluxDBTemplate.class, influxDBTemplate);
                    Singleton.INST.single(MonitorConfig.class, monitorConfig);
                }
            } else if (PluginEnum.RATE_LIMITER.getName().equals(pluginData.getName())) {
                RateLimiterConfig rateLimiterConfig = (RateLimiterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), RateLimiterConfig.class);
                if (Objects.isNull(Singleton.INST.get(ReactiveRedisTemplate.class)) || Objects.isNull(Singleton.INST.get(RateLimiterConfig.class)) || !rateLimiterConfig.equals((Object)Singleton.INST.get(RateLimiterConfig.class))) {
                    LettuceConnectionFactory lettuceConnectionFactory = this.createLettuceConnectionFactory(rateLimiterConfig);
                    lettuceConnectionFactory.afterPropertiesSet();
                    StringRedisSerializer serializer = new StringRedisSerializer();
                    RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key((RedisSerializer)serializer).value((RedisSerializer)serializer).hashKey((RedisSerializer)serializer).hashValue((RedisSerializer)serializer).build();
                    ReactiveRedisTemplate reactiveRedisTemplate = new ReactiveRedisTemplate((ReactiveRedisConnectionFactory)lettuceConnectionFactory, serializationContext);
                    Singleton.INST.single(ReactiveRedisTemplate.class, reactiveRedisTemplate);
                    Singleton.INST.single(RateLimiterConfig.class, rateLimiterConfig);
                }
            }
        });
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(RateLimiterConfig rateLimiterConfig) {
        if (RedisModeEnum.SENTINEL.getName().equals(rateLimiterConfig.getMode())) {
            return new LettuceConnectionFactory(this.redisSentinelConfiguration(rateLimiterConfig));
        }
        if (RedisModeEnum.CLUSTER.getName().equals(rateLimiterConfig.getMode())) {
            return new LettuceConnectionFactory(this.redisClusterConfiguration(rateLimiterConfig));
        }
        return new LettuceConnectionFactory(this.redisStandaloneConfiguration(rateLimiterConfig));
    }

    protected final RedisStandaloneConfiguration redisStandaloneConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        String[] parts = StringUtils.split((String)rateLimiterConfig.getUrl(), (String)":");
        assert (parts != null);
        config.setHostName(parts[0]);
        config.setPort(Integer.parseInt(parts[1]));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        config.setDatabase(rateLimiterConfig.getDatabase().intValue());
        return config;
    }

    private RedisClusterConfiguration redisClusterConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.setClusterNodes(this.createRedisNode(rateLimiterConfig.getUrl()));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        return config;
    }

    private RedisSentinelConfiguration redisSentinelConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.master(rateLimiterConfig.getMaster());
        config.setSentinels(this.createRedisNode(rateLimiterConfig.getUrl()));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        config.setDatabase(rateLimiterConfig.getDatabase().intValue());
        return config;
    }

    private List<RedisNode> createRedisNode(String url) {
        ArrayList<RedisNode> redisNodes = new ArrayList<RedisNode>();
        List nodes = Splitter.on((String)";").splitToList((CharSequence)url);
        for (String node : nodes) {
            try {
                String[] parts = StringUtils.split((String)node, (String)":");
                Assert.state((Objects.requireNonNull(parts).length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
                redisNodes.add(new RedisNode(parts[0], Integer.valueOf(parts[1]).intValue()));
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Invalid redis sentinel property '" + node + "'", ex);
            }
        }
        return redisNodes;
    }

    private InfluxDBProperties buildByConfig(MonitorConfig monitorConfig) {
        InfluxDBProperties influxDBProperties = new InfluxDBProperties();
        influxDBProperties.setDatabase(monitorConfig.getDatabase());
        influxDBProperties.setUrl(monitorConfig.getUrl());
        influxDBProperties.setUsername(monitorConfig.getUserName());
        influxDBProperties.setPassword(monitorConfig.getPassword());
        influxDBProperties.setConnectTimeout(monitorConfig.getConnectTimeout().intValue());
        influxDBProperties.setReadTimeout(monitorConfig.getReadTimeout().intValue());
        influxDBProperties.setRetentionPolicy(monitorConfig.getRetentionPolicy());
        influxDBProperties.setWriteTimeout(monitorConfig.getWriteTimeout().intValue());
        influxDBProperties.setGzip(monitorConfig.getGzip().booleanValue());
        return influxDBProperties;
    }

    static {
        $VALUES = new PluginConfigHandler[]{INS};
    }
}

