/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.function;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.HystrixHandle;
import org.dromara.soul.common.dto.convert.rule.DubboRuleHandle;
import org.dromara.soul.common.dto.convert.selector.DubboSelectorHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.dubbo.DubboProxyService;
import org.dromara.soul.web.plugin.hystrix.DubboCommand;
import org.dromara.soul.web.plugin.hystrix.HystrixBuilder;
import org.dromara.soul.web.request.RequestDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Subscription;

public class DubboPlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboPlugin.class);
    private final DubboProxyService dubboProxyService;

    public DubboPlugin(LocalCacheManager localCacheManager, DubboProxyService dubboProxyService) {
        super(localCacheManager);
        this.dubboProxyService = dubboProxyService;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        Map paramMap = (Map)exchange.getAttribute("dubbo_params");
        DubboRuleHandle ruleHandle = (DubboRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), DubboRuleHandle.class);
        DubboSelectorHandle selectorHandle = (DubboSelectorHandle)GsonUtils.getInstance().fromJson(selector.getHandle(), DubboSelectorHandle.class);
        if (StringUtils.isBlank((CharSequence)ruleHandle.getGroupKey())) {
            ruleHandle.setGroupKey(String.valueOf(Objects.requireNonNull(paramMap).get("interfaceName")));
        }
        if (StringUtils.isBlank((CharSequence)ruleHandle.getCommandKey())) {
            ruleHandle.setCommandKey(String.valueOf(Objects.requireNonNull(paramMap).get("method")));
        }
        if (!this.checkData(selectorHandle)) {
            return chain.execute(exchange);
        }
        DubboCommand command = new DubboCommand(HystrixBuilder.build((HystrixHandle)ruleHandle), paramMap, exchange, chain, this.dubboProxyService, selectorHandle, ruleHandle);
        return Mono.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
            if (command.isCircuitBreakerOpen()) {
                LogUtils.error((Logger)LOGGER, () -> ruleHandle.getGroupKey() + ":dubbo execute circuitBreaker is Open !");
            }
        }).doOnError(throwable -> {
            throwable.printStackTrace();
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            chain.execute(exchange);
        }).then();
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public String named() {
        return PluginEnum.DUBBO.getName();
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO body = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (body != null);
        return !Objects.equals(body.getRpcType(), RpcTypeEnum.DUBBO.getName());
    }

    @Override
    public int getOrder() {
        return PluginEnum.DUBBO.getCode();
    }

    private boolean checkData(DubboSelectorHandle dubboSelectorHandle) {
        if (StringUtils.isBlank((CharSequence)dubboSelectorHandle.getRegistry()) || StringUtils.isBlank((CharSequence)dubboSelectorHandle.getAppName())) {
            LogUtils.error((Logger)LOGGER, () -> "dubbo handle require param not configuration!");
            return false;
        }
        return true;
    }
}

