/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.hystrix;

import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixObservableCommand;
import org.dromara.soul.common.dto.convert.HystrixHandle;

public class HystrixBuilder {
    public static HystrixObservableCommand.Setter build(HystrixHandle hystrixHandle) {
        if (hystrixHandle.getMaxConcurrentRequests() == 0) {
            hystrixHandle.setMaxConcurrentRequests(100);
        }
        if (hystrixHandle.getErrorThresholdPercentage() == 0) {
            hystrixHandle.setErrorThresholdPercentage(50);
        }
        if (hystrixHandle.getRequestVolumeThreshold() == 0) {
            hystrixHandle.setRequestVolumeThreshold(20);
        }
        if (hystrixHandle.getSleepWindowInMilliseconds() == 0) {
            hystrixHandle.setSleepWindowInMilliseconds(5000);
        }
        HystrixCommandGroupKey groupKey = HystrixCommandGroupKey.Factory.asKey((String)hystrixHandle.getGroupKey());
        HystrixCommandKey commandKey = HystrixCommandKey.Factory.asKey((String)hystrixHandle.getCommandKey());
        HystrixCommandProperties.Setter propertiesSetter = HystrixCommandProperties.Setter().withExecutionTimeoutInMilliseconds(hystrixHandle.getTimeout().intValue()).withCircuitBreakerEnabled(true).withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE).withExecutionIsolationSemaphoreMaxConcurrentRequests(hystrixHandle.getMaxConcurrentRequests()).withCircuitBreakerErrorThresholdPercentage(hystrixHandle.getErrorThresholdPercentage()).withCircuitBreakerRequestVolumeThreshold(hystrixHandle.getRequestVolumeThreshold()).withCircuitBreakerSleepWindowInMilliseconds(hystrixHandle.getSleepWindowInMilliseconds());
        return HystrixObservableCommand.Setter.withGroupKey((HystrixCommandGroupKey)groupKey).andCommandKey(commandKey).andCommandPropertiesDefaults(propertiesSetter);
    }
}

