/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.web.cache.AbstractLocalCacheManager;
import org.dromara.soul.web.cache.UpstreamCacheManager;

class CommonCacheHandler
extends AbstractLocalCacheManager {
    CommonCacheHandler() {
    }

    void deleteSelectorData(SelectorData selectorData) {
        if (selectorData.getPluginName().equals(PluginEnum.DIVIDE.getName())) {
            UpstreamCacheManager.removeByKey(selectorData.getId());
        }
        List existList = (List)SELECTOR_MAP.get(selectorData.getPluginName());
        existList.removeIf(e -> e.getId().equals(selectorData.getId()));
    }

    void cacheSelectorData(SelectorData selectorData) {
        String key;
        if (selectorData.getPluginName().equals(PluginEnum.DIVIDE.getName())) {
            UpstreamCacheManager.submit(selectorData);
        }
        if (SELECTOR_MAP.containsKey(key = selectorData.getPluginName())) {
            List existList = (List)SELECTOR_MAP.get(key);
            List resultList = existList.stream().filter(r -> !r.getId().equals(selectorData.getId())).collect(Collectors.toList());
            resultList.add(selectorData);
            List collect = resultList.stream().sorted(Comparator.comparing(SelectorData::getSort)).collect(Collectors.toList());
            SELECTOR_MAP.put(key, collect);
        } else {
            SELECTOR_MAP.put(key, Lists.newArrayList((Object[])new SelectorData[]{selectorData}));
        }
    }

    void cacheRuleData(RuleData ruleData) {
        String key = ruleData.getSelectorId();
        if (RULE_MAP.containsKey(key)) {
            List existList = (List)RULE_MAP.get(key);
            List resultList = existList.stream().filter(r -> !r.getId().equals(ruleData.getId())).collect(Collectors.toList());
            resultList.add(ruleData);
            List collect = resultList.stream().sorted(Comparator.comparing(RuleData::getSort)).collect(Collectors.toList());
            RULE_MAP.put(key, collect);
        } else {
            RULE_MAP.put(key, Lists.newArrayList((Object[])new RuleData[]{ruleData}));
        }
    }
}

