/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.concurrent.SoulThreadFactory;
import org.dromara.soul.common.constant.HttpConstants;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.ConfigData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.ConfigGroupEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.web.cache.HttpCacheHandler;
import org.dromara.soul.web.config.SoulConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttp3ClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class HttpLongPollSyncCache
extends HttpCacheHandler
implements CommandLineRunner,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpLongPollSyncCache.class);
    private static final AtomicBoolean RUNNING = new AtomicBoolean(false);
    private static final ConcurrentMap<ConfigGroupEnum, ConfigData> GROUP_CACHE = new ConcurrentHashMap<ConfigGroupEnum, ConfigData>();
    private static final Gson GSON = new Gson();
    private Duration connectionTimeout = Duration.ofSeconds(10L);
    private RestTemplate httpClient;
    private ExecutorService executor;
    private SoulConfig.HttpConfig httpConfig;
    private List<String> serverList;

    public HttpLongPollSyncCache(SoulConfig.HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
        this.serverList = Lists.newArrayList((Iterable)Splitter.on((String)",").split((CharSequence)httpConfig.getUrl()));
    }

    public void run(String ... args) {
        OkHttp3ClientHttpRequestFactory factory = new OkHttp3ClientHttpRequestFactory();
        factory.setConnectTimeout((int)this.connectionTimeout.toMillis());
        factory.setReadTimeout((int)HttpConstants.CLIENT_POLLING_READ_TIMEOUT);
        this.httpClient = new RestTemplate((ClientHttpRequestFactory)factory);
        if (RUNNING.compareAndSet(false, true)) {
            this.fetchGroupConfig(ConfigGroupEnum.values());
            this.executor = new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), SoulThreadFactory.create((String)"http-long-polling", (boolean)true));
            this.executor.execute(new HttpLongPollingTask());
        } else {
            LOGGER.info("soul http long polling was started, executor=[{}]", (Object)this.executor);
        }
    }

    public void destroy() {
        RUNNING.set(false);
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private void fetchGroupConfig(ConfigGroupEnum ... groups) throws SoulException {
        StringBuilder params = new StringBuilder();
        for (ConfigGroupEnum groupKey : groups) {
            params.append("groupKeys").append("=").append(groupKey.name()).append("&");
        }
        SoulException ex = null;
        for (String server : this.serverList) {
            String url = server + "/configs/fetch?" + StringUtils.removeEnd((String)params.toString(), (String)"&");
            LOGGER.info("request configs: [{}]", (Object)url);
            try {
                String json = (String)this.httpClient.getForObject(url, String.class, new Object[0]);
                LOGGER.info("get latest configs: [{}]", (Object)json);
                this.updateCacheWithJson(json);
                return;
            }
            catch (Exception e) {
                LOGGER.warn("request configs fail, server:[{}]", (Object)server);
                ex = new SoulException("Init cache error, serverList:" + this.httpConfig.getUrl(), (Throwable)e);
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private void updateCacheWithJson(String json) {
        JsonObject metaData;
        JsonObject appAuthData;
        JsonObject selectorData;
        JsonObject ruleData;
        JsonObject jsonObject = (JsonObject)GSON.fromJson(json, JsonObject.class);
        JsonObject data = jsonObject.getAsJsonObject("data");
        JsonObject pluginData = data.getAsJsonObject(ConfigGroupEnum.PLUGIN.name());
        if (pluginData != null) {
            ConfigData result = (ConfigData)GSON.fromJson((JsonElement)pluginData, new TypeToken<ConfigData<PluginData>>(){}.getType());
            GROUP_CACHE.put(ConfigGroupEnum.PLUGIN, result);
            this.flushAllPlugin(result.getData());
        }
        if ((ruleData = data.getAsJsonObject(ConfigGroupEnum.RULE.name())) != null) {
            ConfigData result = (ConfigData)GSON.fromJson((JsonElement)ruleData, new TypeToken<ConfigData<RuleData>>(){}.getType());
            GROUP_CACHE.put(ConfigGroupEnum.RULE, result);
            this.flushAllRule(result.getData());
        }
        if ((selectorData = data.getAsJsonObject(ConfigGroupEnum.SELECTOR.name())) != null) {
            ConfigData result = (ConfigData)GSON.fromJson((JsonElement)selectorData, new TypeToken<ConfigData<SelectorData>>(){}.getType());
            GROUP_CACHE.put(ConfigGroupEnum.SELECTOR, result);
            this.flushAllSelector(result.getData());
        }
        if ((appAuthData = data.getAsJsonObject(ConfigGroupEnum.APP_AUTH.name())) != null) {
            ConfigData result = (ConfigData)GSON.fromJson((JsonElement)appAuthData, new TypeToken<ConfigData<AppAuthData>>(){}.getType());
            GROUP_CACHE.put(ConfigGroupEnum.APP_AUTH, result);
            this.flushAllAppAuth(result.getData());
        }
        if ((metaData = data.getAsJsonObject(ConfigGroupEnum.META_DATA.name())) != null) {
            ConfigData result = (ConfigData)GSON.fromJson((JsonElement)metaData, new TypeToken<ConfigData<MetaData>>(){}.getType());
            GROUP_CACHE.put(ConfigGroupEnum.META_DATA, result);
            this.flushMetaData(result.getData());
        }
    }

    private void doLongPolling() {
        LinkedMultiValueMap params = new LinkedMultiValueMap(16);
        for (ConfigGroupEnum group : ConfigGroupEnum.values()) {
            ConfigData cacheConfig = (ConfigData)GROUP_CACHE.get(group);
            String value = String.join((CharSequence)",", cacheConfig.getMd5(), String.valueOf(cacheConfig.getLastModifyTime()));
            params.put((Object)group.name(), (Object)Lists.newArrayList((Object[])new String[]{value}));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity httpEntity = new HttpEntity((Object)params, (MultiValueMap)headers);
        for (String server : this.serverList) {
            String listenerUrl = server + "/configs/listener";
            LOGGER.debug("request listener configs: [{}]", (Object)listenerUrl);
            try {
                Object[] changedGroups;
                String json = (String)this.httpClient.postForEntity(listenerUrl, (Object)httpEntity, String.class, new Object[0]).getBody();
                LOGGER.debug("listener result: [{}]", (Object)json);
                JsonArray groupJson = ((JsonObject)GSON.fromJson(json, JsonObject.class)).getAsJsonArray("data");
                if (groupJson == null || !ArrayUtils.isNotEmpty((Object[])(changedGroups = (ConfigGroupEnum[])GSON.fromJson((JsonElement)groupJson, ConfigGroupEnum[].class)))) break;
                LOGGER.info("Group config changed: {}", (Object)Arrays.toString(changedGroups));
                this.fetchGroupConfig((ConfigGroupEnum[])changedGroups);
                break;
            }
            catch (RestClientException e) {
                LOGGER.error("listener configs fail, can not connection this server:[{}]", (Object)listenerUrl);
            }
        }
    }

    class HttpLongPollingTask
    implements Runnable {
        HttpLongPollingTask() {
        }

        @Override
        public void run() {
            while (RUNNING.get()) {
                try {
                    HttpLongPollSyncCache.this.doLongPolling();
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            LOGGER.warn("Stop http long polling.");
        }
    }
}

