/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.constant.ZkPathConstants;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.web.cache.AbstractLocalCacheManager;
import org.dromara.soul.web.cache.CommonCacheHandler;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.plugin.dubbo.ApplicationConfigCache;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.CommandLineRunner;

public class ZookeeperSyncCache
extends CommonCacheHandler
implements CommandLineRunner,
DisposableBean {
    private final ZkClient zkClient;

    public ZookeeperSyncCache(ZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public void run(String ... args) {
        this.watcherData();
        this.watchAppAuth();
        this.watchMetaData();
    }

    private void watcherData() {
        String pluginParent = "/soul-open/plugin";
        if (!this.zkClient.exists("/soul-open/plugin")) {
            this.zkClient.createPersistent("/soul-open/plugin", true);
        }
        List pluginZKs = this.zkClient.getChildren(ZkPathConstants.buildPluginParentPath());
        for (String pluginName : pluginZKs) {
            this.loadPlugin(pluginName);
        }
        this.zkClient.subscribeChildChanges("/soul-open/plugin", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                for (String pluginName : currentChildren) {
                    this.loadPlugin(pluginName);
                }
            }
        });
    }

    private void loadPlugin(String pluginName) {
        this.watcherPlugin(pluginName);
        this.watcherSelector(pluginName);
        this.watcherRule(pluginName);
    }

    private void watcherPlugin(final String pluginName) {
        String pluginPath = ZkPathConstants.buildPluginPath((String)pluginName);
        if (!this.zkClient.exists(pluginPath)) {
            this.zkClient.createPersistent(pluginPath, true);
        }
        PluginData data = (PluginData)this.zkClient.readData(pluginPath);
        Optional.ofNullable(data).ifPresent(d -> {
            this.configPlugin(Collections.singletonList(d));
            PLUGIN_MAP.put(data.getName(), data);
        });
        this.zkClient.subscribeDataChanges(pluginPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> {
                    PluginData pluginData = (PluginData)d;
                    ZookeeperSyncCache.this.configPlugin(Collections.singletonList(pluginData));
                    AbstractLocalCacheManager.PLUGIN_MAP.put(pluginData.getName(), pluginData);
                });
            }

            public void handleDataDeleted(String dataPath) {
                AbstractLocalCacheManager.PLUGIN_MAP.remove(pluginName);
            }
        });
    }

    private void watcherSelector(String pluginName) {
        List childrenList;
        String selectorParentPath = ZkPathConstants.buildSelectorParentPath((String)pluginName);
        if (!this.zkClient.exists(selectorParentPath)) {
            this.zkClient.createPersistent(selectorParentPath, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren(selectorParentPath)))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(selectorParentPath, (String)children);
                this.setSelectorData(realPath);
                this.subscribeSelectorDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(selectorParentPath, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = this.buildRealPath(parentPath, (String)addPath);
                    this.setSelectorData(realPath);
                    return realPath;
                }).forEach(this::subscribeSelectorDataChanges);
            }
        });
    }

    private void watcherRule(String pluginName) {
        List childrenList;
        String ruleParent = ZkPathConstants.buildRuleParentPath((String)pluginName);
        if (!this.zkClient.exists(ruleParent)) {
            this.zkClient.createPersistent(ruleParent, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren(ruleParent)))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath(ruleParent, (String)children);
                this.setRuleData(realPath);
                this.subscribeRuleDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges(ruleParent, (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(addPath -> {
                    String realPath = this.buildRealPath(parentPath, (String)addPath);
                    this.setRuleData(realPath);
                    return realPath;
                }).forEach(this::subscribeRuleDataChanges);
            }
        });
    }

    private void subscribeSelectorDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> ZookeeperSyncCache.this.cacheSelectorData((SelectorData)d));
            }

            public void handleDataDeleted(String dataPath) {
                String id = dataPath.substring(dataPath.lastIndexOf("/") + 1);
                String str = dataPath.substring("/soul-open/selector".length());
                String key = str.substring(1, str.length() - id.length() - 1);
                Optional.of(key).ifPresent(k -> {
                    List selectorDataList = (List)AbstractLocalCacheManager.SELECTOR_MAP.get(k);
                    selectorDataList.removeIf(e -> e.getId().equals(id));
                    UpstreamCacheManager.removeByKey(k);
                });
            }
        });
    }

    private void setSelectorData(String realPath) {
        SelectorData selectorData = (SelectorData)this.zkClient.readData(realPath);
        Optional.ofNullable(selectorData).ifPresent(s -> this.cacheSelectorData(selectorData));
    }

    private void setRuleData(String rulePath) {
        RuleData ruleData = (RuleData)this.zkClient.readData(rulePath);
        Optional.ofNullable(ruleData).ifPresent(this::cacheRuleData);
    }

    private void subscribeRuleDataChanges(String path) {
        this.zkClient.subscribeDataChanges(path, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(d -> ZookeeperSyncCache.this.cacheRuleData((RuleData)d));
            }

            public void handleDataDeleted(String dataPath) {
                ArrayList list = Lists.newArrayList((Iterable)Splitter.on((String)"-").split((CharSequence)dataPath.substring(dataPath.lastIndexOf("/") + 1)));
                String selectorId = (String)list.get(0);
                String ruleId = (String)list.get(1);
                Optional.ofNullable(selectorId).ifPresent(k -> {
                    UpstreamCacheManager.removeByKey(selectorId);
                    List ruleDataList = (List)AbstractLocalCacheManager.RULE_MAP.get(selectorId);
                    ruleDataList.removeIf(rule -> rule.getId().equals(ruleId));
                });
            }
        });
    }

    private void watchAppAuth() {
        List childrenList;
        String appAuthParent = "/soul-open/auth";
        if (!this.zkClient.exists("/soul-open/auth")) {
            this.zkClient.createPersistent("/soul-open/auth", true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren("/soul-open/auth")))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/soul-open/auth", (String)children);
                this.setAuthData(realPath);
                this.subscribeAppAuthDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges("/soul-open/auth", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(children -> {
                    String realPath = this.buildRealPath(parentPath, (String)children);
                    this.setAuthData(realPath);
                    return realPath;
                }).forEach(this::subscribeAppAuthDataChanges);
            }
        });
    }

    private void watchMetaData() {
        List childrenList;
        String metaDataPath = "/soul-open/metaData";
        if (!this.zkClient.exists("/soul-open/metaData")) {
            this.zkClient.createPersistent("/soul-open/metaData", true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(childrenList = this.zkClient.getChildren("/soul-open/metaData")))) {
            childrenList.forEach(children -> {
                String realPath = this.buildRealPath("/soul-open/metaData", (String)children);
                this.setMetaData(realPath);
                this.subscribeMetaDataChanges(realPath);
            });
        }
        this.zkClient.subscribeChildChanges("/soul-open/metaData", (parentPath, currentChildren) -> {
            if (CollectionUtils.isNotEmpty((Collection)currentChildren)) {
                List<String> addSubscribePath = this.addSubscribePath(childrenList, currentChildren);
                addSubscribePath.stream().map(children -> {
                    String realPath = this.buildRealPath(parentPath, (String)children);
                    this.setMetaData(realPath);
                    return realPath;
                }).forEach(this::subscribeMetaDataChanges);
            }
        });
    }

    private void subscribeMetaDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable((MetaData)data).ifPresent(metaData -> {
                    ZookeeperSyncCache.this.initDubboRef(Collections.singletonList(metaData));
                    AbstractLocalCacheManager.META_DATA.put(metaData.getPath(), (MetaData)metaData);
                });
            }

            public void handleDataDeleted(String dataPath) {
                MetaData metaData = (MetaData)ZookeeperSyncCache.this.zkClient.readData(dataPath);
                Optional.ofNullable(metaData).ifPresent(d -> {
                    AbstractLocalCacheManager.META_DATA.remove(d.getPath());
                    ApplicationConfigCache.getInstance().invalidate(d.getServiceName());
                });
            }
        });
    }

    private void setMetaData(String realPath) {
        MetaData metaData = (MetaData)this.zkClient.readData(realPath);
        this.initDubboRef(Collections.singletonList(metaData));
        Optional.ofNullable(metaData).ifPresent(dto -> META_DATA.put(dto.getPath(), dto));
    }

    private void setAuthData(String realPath) {
        AppAuthData appAuthData = (AppAuthData)this.zkClient.readData(realPath);
        Optional.ofNullable(appAuthData).ifPresent(dto -> AUTH_MAP.put(dto.getAppKey(), dto));
    }

    private void subscribeAppAuthDataChanges(String realPath) {
        this.zkClient.subscribeDataChanges(realPath, new IZkDataListener(){

            public void handleDataChange(String dataPath, Object data) {
                Optional.ofNullable(data).ifPresent(o -> AbstractLocalCacheManager.AUTH_MAP.put(((AppAuthData)o).getAppKey(), (AppAuthData)o));
            }

            public void handleDataDeleted(String dataPath) {
                String key = dataPath.substring("/soul-open/auth".length() + 1);
                AbstractLocalCacheManager.AUTH_MAP.remove(key);
            }
        });
    }

    private List<String> addSubscribePath(List<String> alreadyChildren, List<String> currentChildren) {
        if (CollectionUtils.isEmpty(alreadyChildren)) {
            return currentChildren;
        }
        return currentChildren.stream().filter(current -> alreadyChildren.stream().noneMatch(current::equals)).collect(Collectors.toList());
    }

    private String buildRealPath(String parent, String children) {
        return parent + "/" + children;
    }

    public void destroy() {
        this.zkClient.close();
    }
}

