/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.condition.strategy;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.dromara.soul.common.dto.ConditionData;
import org.dromara.soul.common.enums.ParamTypeEnum;
import org.dromara.soul.common.utils.ReflectUtils;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.support.HostAddressUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

abstract class AbstractMatchStrategy {
    AbstractMatchStrategy() {
    }

    String buildRealData(ConditionData condition, ServerWebExchange exchange) {
        String realData = "";
        ParamTypeEnum paramTypeEnum = ParamTypeEnum.getParamTypeEnumByName((String)condition.getParamType());
        switch (paramTypeEnum) {
            case HEADER: {
                HttpHeaders headers = exchange.getRequest().getHeaders();
                List list = headers.get((Object)condition.getParamName());
                if (CollectionUtils.isEmpty((Collection)list)) {
                    return realData;
                }
                realData = Objects.requireNonNull(headers.get((Object)condition.getParamName())).stream().findFirst().orElse("");
                break;
            }
            case URI: {
                realData = exchange.getRequest().getURI().getPath();
                break;
            }
            case QUERY: {
                MultiValueMap queryParams = exchange.getRequest().getQueryParams();
                realData = (String)queryParams.getFirst((Object)condition.getParamName());
                break;
            }
            case HOST: {
                realData = HostAddressUtils.acquireHost(exchange);
                break;
            }
            case IP: {
                realData = HostAddressUtils.acquireIp(exchange);
                break;
            }
            case POST: {
                RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
                realData = (String)ReflectUtils.getFieldValue((Object)requestDTO, (String)condition.getParamName());
                break;
            }
        }
        return realData;
    }
}

