/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import org.I0Itec.zkclient.ZkClient;
import org.dromara.soul.configuration.zookeeper.ZookeeperConfiguration;
import org.dromara.soul.web.cache.HttpLongPollSyncCache;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.cache.WebsocketSyncCache;
import org.dromara.soul.web.cache.ZookeeperSyncCache;
import org.dromara.soul.web.config.SoulConfig;
import org.dromara.soul.web.configuration.SoulConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@AutoConfigureBefore(value={SoulConfiguration.class})
@EnableConfigurationProperties(value={SoulConfig.class})
public class LocalCacheConfiguration {

    @Configuration
    @ConditionalOnMissingBean(value={LocalCacheManager.class})
    @ConditionalOnProperty(name={"soul.sync.strategy"}, havingValue="websocket", matchIfMissing=true)
    static class WebsocketCacheManager {
        WebsocketCacheManager() {
        }

        @Bean
        public LocalCacheManager localCacheManager(SoulConfig soulConfig) {
            return new WebsocketSyncCache(soulConfig.getSync().getWebsocket());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={LocalCacheManager.class})
    @ConditionalOnProperty(name={"soul.sync.strategy"}, havingValue="http")
    static class HttpCacheManager {
        HttpCacheManager() {
        }

        @Bean
        public LocalCacheManager localCacheManager(SoulConfig soulConfig) {
            return new HttpLongPollSyncCache(soulConfig.getSync().getHttp());
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={LocalCacheManager.class})
    @ConditionalOnProperty(name={"soul.sync.strategy"}, havingValue="zookeeper")
    @Import(value={ZookeeperConfiguration.class})
    static class ZookeeperCacheManager {
        ZookeeperCacheManager() {
        }

        @Bean
        public LocalCacheManager localCacheManager(ZkClient zkClient) {
            return new ZookeeperSyncCache(zkClient);
        }
    }
}

