/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.disruptor.publisher;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.IgnoreExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.WorkHandler;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.dromara.soul.common.concurrent.SoulThreadFactory;
import org.dromara.soul.web.disruptor.event.SoulDataEvent;
import org.dromara.soul.web.disruptor.factory.SoulEventFactory;
import org.dromara.soul.web.disruptor.handler.SoulDataHandler;
import org.dromara.soul.web.disruptor.translator.SoulEventTranslator;
import org.dromara.soul.web.influxdb.entity.MonitorDO;
import org.dromara.soul.web.influxdb.service.InfluxDbService;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class SoulEventPublisher
implements InitializingBean,
DisposableBean {
    private Disruptor<SoulDataEvent> disruptor;
    private final InfluxDbService influxDbService;
    @Value(value="${soul.disruptor.bufferSize:4096}")
    private int bufferSize;
    @Value(value="${soul.disruptor.threadSize:16}")
    private int threadSize;
    @Value(value="${soul.disruptor.taskQueueSize:4096}")
    private int threadPoolQueueSize;

    public SoulEventPublisher(InfluxDbService influxDbService) {
        this.influxDbService = influxDbService;
    }

    private void start() {
        this.disruptor = new Disruptor((EventFactory)new SoulEventFactory(), this.bufferSize, SoulThreadFactory.create((String)"monitor-disruptor-thread-", (boolean)false), ProducerType.MULTI, (WaitStrategy)new BlockingWaitStrategy());
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.threadSize, this.threadSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.threadPoolQueueSize), SoulThreadFactory.create((String)"monitor-disruptor-executor", (boolean)false), new ThreadPoolExecutor.AbortPolicy());
        WorkHandler[] consumers = new SoulDataHandler[this.threadSize];
        for (int i = 0; i < this.threadSize; ++i) {
            consumers[i] = new SoulDataHandler(executor, this.influxDbService);
        }
        this.disruptor.handleEventsWithWorkerPool(consumers);
        this.disruptor.setDefaultExceptionHandler((ExceptionHandler)new IgnoreExceptionHandler());
        this.disruptor.start();
    }

    public void publishEvent(MonitorDO monitorDO) {
        RingBuffer ringBuffer = this.disruptor.getRingBuffer();
        ringBuffer.publishEvent((EventTranslatorOneArg)new SoulEventTranslator(), (Object)monitorDO);
    }

    public void destroy() {
        this.disruptor.shutdown();
    }

    public void afterPropertiesSet() {
        this.start();
    }
}

