/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import java.util.List;
import java.util.Map;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.filter.support.BodyInserterContext;
import org.dromara.soul.web.filter.support.CachedBodyOutputMessage;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultWarp;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FileSizeFilter
implements WebFilter {
    private static final long BYTES_PER_MB = 0x100000L;
    @Value(value="${file.size:10}")
    private int maxSize;
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();

    public Mono<Void> filter(@NonNull ServerWebExchange exchange, @NonNull WebFilterChain chain) {
        MediaType mediaType = exchange.getRequest().getHeaders().getContentType();
        if (MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType)) {
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
            return serverRequest.bodyToMono(DataBuffer.class).flatMap(size -> {
                if ((long)size.capacity() > 0x100000L * (long)this.maxSize) {
                    ServerHttpResponse response = exchange.getResponse();
                    response.setStatusCode(HttpStatus.BAD_REQUEST);
                    Object error = SoulResultWarp.error(SoulResultEnum.PAYLOAD_TOO_LARGE.getCode(), SoulResultEnum.PAYLOAD_TOO_LARGE.getMsg(), null);
                    return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(GsonUtils.getInstance().toJson(error).getBytes())));
                }
                BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)Mono.just((Object)size), DataBuffer.class);
                HttpHeaders headers = new HttpHeaders();
                headers.putAll((Map)exchange.getRequest().getHeaders());
                headers.remove((Object)"Content-Length");
                CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, headers);
                return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                    ServerHttpRequestDecorator decorator = this.decorate(exchange, outputMessage);
                    return chain.filter(exchange.mutate().request((ServerHttpRequest)decorator).build());
                }));
            });
        }
        return chain.filter(exchange);
    }

    private ServerHttpRequestDecorator decorate(ServerWebExchange exchange, final CachedBodyOutputMessage outputMessage) {
        return new ServerHttpRequestDecorator(exchange.getRequest()){

            public Flux<DataBuffer> getBody() {
                return outputMessage.getBody();
            }
        };
    }
}

