/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.after;

import java.util.Objects;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.JsonUtils;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DubboResponsePlugin
implements SoulPlugin {
    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        return chain.execute(exchange).then(Mono.defer(() -> {
            Object result = exchange.getAttribute("dubbo_rpc_result");
            try {
                if (Objects.isNull(result)) {
                    Object error = SoulResultWarp.error(SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
                    return SoulResultUtils.result(exchange, error);
                }
                return SoulResultUtils.result(exchange, JsonUtils.removeClass((Object)result));
            }
            catch (SoulException e) {
                return Mono.empty();
            }
        }));
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.LAST;
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        return !Objects.equals(requestDTO.getRpcType(), RpcTypeEnum.DUBBO.getName());
    }

    @Override
    public int getOrder() {
        return PluginEnum.RESPONSE.getCode();
    }

    @Override
    public String named() {
        return PluginEnum.RESPONSE.getName();
    }
}

