/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.before;

import java.util.Objects;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.WafHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.WafEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WafPlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(WafPlugin.class);

    public WafPlugin(LocalCacheManager localCacheManager) {
        super(localCacheManager);
    }

    @Override
    public String named() {
        return PluginEnum.WAF.getName();
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        @NotBlank String handle = rule.getHandle();
        WafHandle wafHandle = (WafHandle)GsonUtils.getInstance().fromJson(handle, WafHandle.class);
        if (Objects.isNull(wafHandle) || StringUtils.isBlank((CharSequence)wafHandle.getPermission())) {
            LogUtils.error((Logger)LOGGER, (String)"waf handler can not configuration\uff1a{}", () -> handle);
            return chain.execute(exchange);
        }
        if (WafEnum.REJECT.getName().equals(wafHandle.getPermission())) {
            exchange.getResponse().setStatusCode(HttpStatus.FORBIDDEN);
            Object error = SoulResultWarp.error(Integer.parseInt(wafHandle.getStatusCode()), " You are forbidden to visit", null);
            return SoulResultUtils.result(exchange, error);
        }
        return chain.execute(exchange);
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.BEFORE;
    }

    @Override
    public int getOrder() {
        return PluginEnum.WAF.getCode();
    }
}

