/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.hystrix.HttpCommand;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyPipeline;
import reactor.netty.http.client.HttpClient;

public class NettyHttpClientPlugin
implements SoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommand.class);
    private final HttpClient httpClient;

    public NettyHttpClientPlugin(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        RequestDTO body = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (body != null);
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethodValue());
        HttpHeaders filtered = request.getHeaders();
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        filtered.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)httpHeaders).set(arg_0, arg_1));
        String url = (String)exchange.getAttribute("httpUrl");
        if (StringUtils.isEmpty((Object)url)) {
            Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_FIND_URL.getCode(), SoulResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return SoulResultUtils.result(exchange, error);
        }
        LOGGER.info("you request,The resulting urlPath is :{}", (Object)url);
        Flux responseFlux = ((HttpClient.RequestSender)this.httpClient.headers(headers -> headers.add((io.netty.handler.codec.http.HttpHeaders)httpHeaders)).request(method).uri(url)).send((req, nettyOutbound) -> nettyOutbound.options(NettyPipeline.SendOptions::flushOnEach).send((Publisher)request.getBody().map(dataBuffer -> ((NettyDataBuffer)dataBuffer).getNativeBuffer()))).responseConnection((res, connection) -> {
            HttpStatus status;
            exchange.getAttributes().put("webHandlerClientResponse", res);
            exchange.getAttributes().put("nettyClientResponseConnection", connection);
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            String contentTypeValue = headers.getFirst("Content-Type");
            if (StringUtils.hasLength((String)contentTypeValue)) {
                exchange.getAttributes().put("original_response_content_type", contentTypeValue);
            }
            if ((status = HttpStatus.resolve((int)res.status().code())) != null) {
                response.setStatusCode(status);
            } else if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setStatusCodeValue(Integer.valueOf(res.status().code()));
            } else {
                throw new IllegalStateException("Unable to set status code on response: " + res.status().code() + ", " + response.getClass());
            }
            response.getHeaders().putAll((Map)headers);
            return Mono.just((Object)res);
        });
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        Duration duration = Duration.ofMillis(timeout);
        responseFlux = responseFlux.timeout(duration, (Publisher)Mono.error((Throwable)new TimeoutException("Response took longer than timeout: " + duration))).onErrorMap(TimeoutException.class, th -> new ResponseStatusException(HttpStatus.GATEWAY_TIMEOUT, th.getMessage(), (Throwable)th));
        return responseFlux.then(chain.execute(exchange));
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.DIVIDE.getCode() + 1;
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), requestDTO.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), requestDTO.getRpcType());
    }

    @Override
    public String named() {
        return "NettyHttpClient";
    }
}

