/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.balance.spi;

import java.util.List;
import java.util.Random;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.extension.Join;
import org.dromara.soul.web.balance.spi.AbstractLoadBalance;

@Join
public class RandomLoadBalance
extends AbstractLoadBalance {
    private static final Random RANDOM = new Random();

    @Override
    public DivideUpstream doSelect(List<DivideUpstream> upstreamList, String ip) {
        int length = upstreamList.size();
        int totalWeight = 0;
        boolean sameWeight = true;
        for (int i = 0; i < length; ++i) {
            int weight = upstreamList.get(i).getWeight();
            totalWeight += weight;
            if (!sameWeight || i <= 0 || weight == upstreamList.get(i - 1).getWeight()) continue;
            sameWeight = false;
        }
        if (totalWeight > 0 && !sameWeight) {
            int offset = RANDOM.nextInt(totalWeight);
            for (DivideUpstream divideUpstream : upstreamList) {
                if ((offset -= divideUpstream.getWeight()) >= 0) continue;
                return divideUpstream;
            }
        }
        return upstreamList.get(RANDOM.nextInt(length));
    }
}

