/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import java.time.LocalDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.web.cache.AbstractLocalCacheManager;
import org.dromara.soul.web.filter.ParamService;
import org.dromara.soul.web.request.RequestDTO;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class DefaultParamService
implements ParamService {
    @Override
    public Mono<Boolean> doParam(ServerWebExchange exchange) {
        ServerHttpRequest request = exchange.getRequest();
        String path = request.getURI().getPath();
        MetaData metaData = AbstractLocalCacheManager.findPath(path);
        if (Objects.isNull(metaData) || !metaData.getEnabled().booleanValue()) {
            return Mono.just((Object)false);
        }
        RequestDTO requestDTO = this.transform(request, metaData);
        if (!this.verify(requestDTO).booleanValue()) {
            return Mono.just((Object)false);
        }
        exchange.getAttributes().put("requestDTO", requestDTO);
        return Mono.just((Object)true);
    }

    private RequestDTO transform(ServerHttpRequest request, MetaData metaData) {
        String appKey = request.getHeaders().getFirst("appKey");
        String sign = request.getHeaders().getFirst("sign");
        String timestamp = request.getHeaders().getFirst("timestamp");
        RequestDTO requestDTO = new RequestDTO();
        String path = request.getURI().getPath();
        String[] splitList = StringUtils.split((String)path, (String)"/");
        String contextPath = "/" + splitList[0];
        String realPath = path.substring(contextPath.length());
        requestDTO.setPath(path);
        requestDTO.setRealUrl(realPath);
        requestDTO.setContextPath(contextPath);
        requestDTO.setModule(metaData.getAppName());
        requestDTO.setMethod(metaData.getServiceName());
        requestDTO.setAppKey(appKey);
        requestDTO.setRpcType(metaData.getRpcType());
        requestDTO.setSign(sign);
        requestDTO.setTimestamp(timestamp);
        requestDTO.setMetaData(metaData);
        requestDTO.setStartDateTime(LocalDateTime.now());
        HttpMethod method = request.getMethod();
        if (Objects.nonNull(method)) {
            requestDTO.setHttpMethod(method.name());
        }
        return requestDTO;
    }

    private Boolean verify(RequestDTO requestDTO) {
        if (Objects.isNull(requestDTO) || StringUtils.isBlank((CharSequence)requestDTO.getModule()) || StringUtils.isBlank((CharSequence)requestDTO.getMethod())) {
            return false;
        }
        RpcTypeEnum rpcTypeEnum = RpcTypeEnum.acquireByName((String)requestDTO.getRpcType());
        return !Objects.isNull(rpcTypeEnum);
    }
}

