/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import java.util.List;
import java.util.Objects;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.web.request.RequestDTO;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class DubboBodyWebFilter
implements WebFilter {
    private final List<HttpMessageReader<?>> messageReaders = HandlerStrategies.withDefaults().messageReaders();

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        if (Objects.nonNull(requestDTO) && RpcTypeEnum.DUBBO.getName().equals(requestDTO.getRpcType())) {
            MediaType mediaType = request.getHeaders().getContentType();
            ServerRequest serverRequest = ServerRequest.create((ServerWebExchange)exchange, this.messageReaders);
            return serverRequest.bodyToMono(String.class).flatMap(body -> {
                if (MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
                    exchange.getAttributes().put("dubbo_params", body);
                }
                return chain.filter(exchange);
            });
        }
        return chain.filter(exchange);
    }
}

