/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.filter;

import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.web.filter.AbstractWebFilter;
import org.dromara.soul.web.filter.ParamService;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class ParamWebFilter
extends AbstractWebFilter {
    private ParamService paramService;

    public ParamWebFilter(ParamService paramService) {
        this.paramService = paramService;
    }

    @Override
    protected Mono<Boolean> doFilter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        String upgrade = headers.getFirst("Upgrade");
        if (StringUtils.isBlank((CharSequence)upgrade) || !RpcTypeEnum.WEB_SOCKET.getName().equals(upgrade)) {
            return this.paramService.doParam(exchange);
        }
        return Mono.just((Object)true);
    }

    @Override
    protected Mono<Void> doDenyResponse(ServerWebExchange exchange) {
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode(HttpStatus.BAD_REQUEST);
        Object error = SoulResultWarp.error(SoulResultEnum.PARAM_ERROR.getCode(), SoulResultEnum.PARAM_ERROR.getMsg(), null);
        return SoulResultUtils.result(exchange, error);
    }
}

