/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.after;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;

public class NettyClientResponsePlugin
implements SoulPlugin {
    private static final Log LOG = LogFactory.getLog(NettyClientResponsePlugin.class);
    private List<MediaType> streamingMediaTypes = Arrays.asList(MediaType.TEXT_EVENT_STREAM, MediaType.APPLICATION_STREAM_JSON);

    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        return Mono.defer(() -> {
            RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
            assert (requestDTO != null);
            Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
            if (connection == null) {
                return Mono.empty();
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("NettyWriteResponseFilter start inbound: " + connection.channel().id().asShortText() + ", outbound: " + exchange.getLogPrefix()));
            }
            ServerHttpResponse response = exchange.getResponse();
            NettyDataBufferFactory factory = (NettyDataBufferFactory)response.bufferFactory();
            Flux body = connection.inbound().receive().retain().map(arg_0 -> ((NettyDataBufferFactory)factory).wrap(arg_0));
            MediaType contentType = response.getHeaders().getContentType();
            return this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
        }).then(chain.execute(exchange).doOnError(throwable -> this.cleanup(exchange))).doOnCancel(() -> this.cleanup(exchange));
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.LAST;
    }

    @Override
    public int getOrder() {
        return 100;
    }

    @Override
    public String named() {
        return "NettyWriteResponse";
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), requestDTO.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), requestDTO.getRpcType());
    }

    private void cleanup(ServerWebExchange exchange) {
        Connection connection = (Connection)exchange.getAttribute("nettyClientResponseConnection");
        if (connection != null) {
            connection.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (contentType == null) return false;
        if (!this.streamingMediaTypes.stream().anyMatch(arg_0 -> ((MediaType)contentType).isCompatibleWith(arg_0))) return false;
        return true;
    }
}

