/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.dubbo;

import com.alibaba.dubbo.config.ApplicationConfig;
import com.alibaba.dubbo.config.ReferenceConfig;
import com.alibaba.dubbo.config.RegistryConfig;
import com.alibaba.dubbo.rpc.service.GenericException;
import com.alibaba.dubbo.rpc.service.GenericService;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.convert.rule.DubboRuleHandle;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.web.plugin.dubbo.ApplicationConfigCache;
import org.dromara.soul.web.plugin.dubbo.GenericParamResolveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DubboProxyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboProxyService.class);
    private static final Map<String, RegistryConfig> REGISTRY_CONFIG_MAP = Maps.newConcurrentMap();
    private static final Map<String, ApplicationConfig> APPLICATION_CONFIG_MAP = Maps.newConcurrentMap();
    private final GenericParamResolveService genericParamResolveService;

    public DubboProxyService(GenericParamResolveService genericParamResolveService) {
        this.genericParamResolveService = genericParamResolveService;
    }

    public Object genericInvoker(String body, MetaData metaData, DubboRuleHandle dubboRuleHandle) throws SoulException {
        GenericService genericService;
        try {
            Object reference = ApplicationConfigCache.getInstance().get(metaData.getServiceName());
            if (Objects.isNull(reference) || StringUtils.isEmpty((CharSequence)reference.getInterface())) {
                ApplicationConfigCache.getInstance().invalidate(metaData.getServiceName());
                reference = ApplicationConfigCache.getInstance().initRef(metaData);
            }
            genericService = (GenericService)reference.get();
        }
        catch (Exception ex) {
            LOGGER.error("dubbo \u6cdb\u5316\u521d\u59cb\u5316\u5f02\u5e38:", (Throwable)ex);
            ApplicationConfigCache.getInstance().invalidate(metaData.getServiceName());
            ReferenceConfig<GenericService> reference = ApplicationConfigCache.getInstance().initRef(metaData);
            genericService = (GenericService)reference.get();
        }
        try {
            if ("".equals(body) || "{}".equals(body) || "null".equals(body)) {
                return genericService.$invoke(metaData.getMethodName(), new String[0], new Object[0]);
            }
            Pair<String[], Object[]> pair = this.genericParamResolveService.buildParameter(body, metaData.getParameterTypes());
            return genericService.$invoke(metaData.getMethodName(), (String[])pair.getLeft(), (Object[])pair.getRight());
        }
        catch (GenericException e) {
            LOGGER.error("dubbo \u6cdb\u5316\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new SoulException(e.getMessage());
        }
    }
}

