/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.function;

import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.dto.convert.HystrixHandle;
import org.dromara.soul.common.dto.convert.rule.DivideRuleHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.balance.utils.LoadBalanceUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.hystrix.HttpCommand;
import org.dromara.soul.web.plugin.hystrix.HystrixBuilder;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Subscription;

public class DividePlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(DividePlugin.class);
    private final UpstreamCacheManager upstreamCacheManager;

    public DividePlugin(LocalCacheManager localCacheManager, UpstreamCacheManager upstreamCacheManager) {
        super(localCacheManager);
        this.upstreamCacheManager = upstreamCacheManager;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        List<DivideUpstream> upstreamList;
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        DivideRuleHandle ruleHandle = (DivideRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), DivideRuleHandle.class);
        if (StringUtils.isBlank((CharSequence)ruleHandle.getGroupKey())) {
            ruleHandle.setGroupKey(Objects.requireNonNull(requestDTO).getModule());
        }
        if (StringUtils.isBlank((CharSequence)ruleHandle.getCommandKey())) {
            ruleHandle.setCommandKey(Objects.requireNonNull(requestDTO).getMethod());
        }
        if (CollectionUtils.isEmpty(upstreamList = this.upstreamCacheManager.findUpstreamListBySelectorId(selector.getId()))) {
            LOGGER.error("divide upstream configuration error\uff1a{}", (Object)rule.toString());
            Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_FIND_URL.getCode(), SoulResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return SoulResultUtils.result(exchange, error);
        }
        String ip = Objects.requireNonNull(exchange.getRequest().getRemoteAddress()).getAddress().getHostAddress();
        DivideUpstream divideUpstream = LoadBalanceUtils.selector(upstreamList, ruleHandle.getLoadBalance(), ip);
        if (Objects.isNull(divideUpstream)) {
            LOGGER.error("divide has no upstream");
            Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_FIND_URL.getCode(), SoulResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return SoulResultUtils.result(exchange, error);
        }
        String domain = this.buildDomain(divideUpstream);
        String realURL = this.buildRealURL(domain, requestDTO, exchange);
        exchange.getAttributes().put("httpUrl", realURL);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        HttpCommand command = new HttpCommand(HystrixBuilder.build((HystrixHandle)ruleHandle), exchange, chain);
        return Mono.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
            if (command.isCircuitBreakerOpen()) {
                LOGGER.error("http execute \u8fc7\u7a0b\u4e2d\u53d1\u751f\u4e86\u7194\u65ad circuitBreaker is Open! \u7ec4key\u4e3a:{}", (Object)ruleHandle.getGroupKey());
            }
        }).doOnError(throwable -> {
            LOGGER.error("http \u8c03\u7528\u5f02\u5e38:", throwable);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            chain.execute(exchange);
        }).then();
    }

    @Override
    public String named() {
        return PluginEnum.DIVIDE.getName();
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO body = (RequestDTO)exchange.getAttribute("requestDTO");
        return !Objects.equals(Objects.requireNonNull(body).getRpcType(), RpcTypeEnum.HTTP.getName());
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.DIVIDE.getCode();
    }

    private String buildDomain(DivideUpstream divideUpstream) {
        String protocol = divideUpstream.getProtocol();
        if (StringUtils.isBlank((CharSequence)protocol)) {
            protocol = "http://";
        }
        return protocol + divideUpstream.getUpstreamUrl().trim();
    }

    private String buildRealURL(String domain, RequestDTO requestDTO, ServerWebExchange exchange) {
        String path = domain;
        String rewriteURI = (String)exchange.getAttributes().get("rewrite_uri");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{rewriteURI})) {
            path = path + rewriteURI;
        } else {
            String realUrl = requestDTO.getRealUrl();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{realUrl})) {
                path = path + realUrl;
            }
        }
        if (requestDTO.getHttpMethod().equals(HttpMethod.GET.name())) {
            String query = exchange.getRequest().getURI().getQuery();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{query})) {
                return path + "?" + query;
            }
        }
        return path;
    }
}

