/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.http;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.hystrix.HttpCommand;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class WebClientPlugin
implements SoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommand.class);
    private final WebClient webClient;

    public WebClientPlugin(WebClient webClient) {
        this.webClient = webClient;
    }

    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        String urlPath = (String)exchange.getAttribute("httpUrl");
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_FIND_URL.getCode(), SoulResultEnum.CANNOT_FIND_URL.getMsg(), null);
            return SoulResultUtils.result(exchange, error);
        }
        long timeout = (Long)Optional.ofNullable(exchange.getAttribute("httpTimeOut")).orElse(3000L);
        LOGGER.info("you request,The resulting urlPath is :{}", (Object)urlPath);
        HttpMethod method = HttpMethod.valueOf((String)exchange.getRequest().getMethodValue());
        WebClient.RequestBodySpec requestBodySpec = (WebClient.RequestBodySpec)this.webClient.method(method).uri(urlPath, new Object[0]);
        return this.handleRequestBody(requestBodySpec, exchange, timeout, chain);
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.DIVIDE.getCode() + 1;
    }

    @Override
    public String named() {
        return "webClient";
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        return !Objects.equals(RpcTypeEnum.HTTP.getName(), requestDTO.getRpcType()) && !Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), requestDTO.getRpcType());
    }

    private MediaType buildMediaType(ServerWebExchange exchange) {
        return MediaType.valueOf((String)Optional.ofNullable(exchange.getRequest().getHeaders().getFirst("Content-Type")).orElse("application/json;charset=UTF-8"));
    }

    private Mono<Void> handleRequestBody(WebClient.RequestBodySpec requestBodySpec, ServerWebExchange exchange, long timeout, SoulPluginChain chain) {
        return ((WebClient.RequestBodySpec)requestBodySpec.headers(httpHeaders -> {
            httpHeaders.addAll((MultiValueMap)exchange.getRequest().getHeaders());
            httpHeaders.remove((Object)"Host");
        })).contentType(this.buildMediaType(exchange)).body(BodyInserters.fromDataBuffers((Publisher)exchange.getRequest().getBody())).exchange().doOnError(e -> LogUtils.error((Logger)LOGGER, e::getMessage)).timeout(Duration.ofMillis(timeout)).flatMap(e -> this.doNext((ClientResponse)e, exchange, chain));
    }

    private Mono<Void> doNext(ClientResponse res, ServerWebExchange exchange, SoulPluginChain chain) {
        if (res.statusCode().is2xxSuccessful()) {
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
        } else {
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
        }
        exchange.getAttributes().put("webHandlerClientResponse", res);
        return chain.execute(exchange);
    }
}

