/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import java.util.Objects;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.convert.rule.DubboRuleHandle;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.dubbo.DubboProxyService;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class DubboCommand
extends HystrixObservableCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DubboCommand.class);
    private final ServerWebExchange exchange;
    private final SoulPluginChain chain;
    private final DubboProxyService dubboProxyService;
    private final String body;
    private final MetaData metaData;
    private final DubboRuleHandle dubboRuleHandle;

    public DubboCommand(HystrixObservableCommand.Setter setter, String body, ServerWebExchange exchange, SoulPluginChain chain, DubboProxyService dubboProxyService, MetaData metaData, DubboRuleHandle dubboRuleHandle) {
        super(setter);
        this.exchange = exchange;
        this.body = body;
        this.chain = chain;
        this.dubboProxyService = dubboProxyService;
        this.metaData = metaData;
        this.dubboRuleHandle = dubboRuleHandle;
    }

    protected Observable<Void> construct() {
        return RxReactiveStreams.toObservable(this.doRpcInvoke());
    }

    private Mono<Void> doRpcInvoke() {
        Object result = this.dubboProxyService.genericInvoker(this.body, this.metaData, this.dubboRuleHandle);
        if (Objects.nonNull(result)) {
            this.exchange.getAttributes().put("dubbo_rpc_result", result);
        } else {
            this.exchange.getAttributes().put("dubbo_rpc_result", "dubbo has not return value!");
        }
        this.exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.SUCCESS.getName());
        return this.chain.execute(this.exchange);
    }

    protected Observable<Void> resumeWithFallback() {
        return RxReactiveStreams.toObservable(this.doFallback());
    }

    private Mono<Void> doFallback() {
        if (this.isFailedExecution()) {
            LogUtils.error((Logger)LOGGER, (String)"dubbo rpc have error:{}", () -> this.getExecutionException().getMessage());
        }
        this.exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        Object error = SoulResultWarp.error(SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        return SoulResultUtils.result(this.exchange, error);
    }
}

