/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.hystrix;

import com.netflix.hystrix.HystrixObservableCommand;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.exception.HystrixTimeoutException;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class HttpCommand
extends HystrixObservableCommand<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCommand.class);
    private final ServerWebExchange exchange;
    private final SoulPluginChain chain;

    public HttpCommand(HystrixObservableCommand.Setter setter, ServerWebExchange exchange, SoulPluginChain chain) {
        super(setter);
        this.exchange = exchange;
        this.chain = chain;
    }

    protected Observable<Void> construct() {
        return RxReactiveStreams.toObservable(this.chain.execute(this.exchange));
    }

    protected Observable<Void> resumeWithFallback() {
        return RxReactiveStreams.toObservable(this.doFallback());
    }

    private Mono<Void> doFallback() {
        Throwable exception;
        if (this.isFailedExecution()) {
            LOGGER.error("http execute have error:", this.getExecutionException());
        }
        if ((exception = this.getExecutionException()) instanceof HystrixRuntimeException) {
            HystrixRuntimeException e = (HystrixRuntimeException)this.getExecutionException();
            if (e.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                this.exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
            } else {
                this.exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
            }
        } else if (exception instanceof HystrixTimeoutException) {
            this.exchange.getResponse().setStatusCode(HttpStatus.GATEWAY_TIMEOUT);
        } else {
            this.exchange.getResponse().setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR);
        }
        Object error = SoulResultWarp.error(SoulResultEnum.SERVICE_RESULT_ERROR.getCode(), SoulResultEnum.SERVICE_RESULT_ERROR.getMsg(), null);
        return SoulResultUtils.result(this.exchange, error);
    }
}

