/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.web.cache.AbstractLocalCacheManager;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.plugin.hystrix.HystrixRefreshHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpCacheHandler
extends AbstractLocalCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpCacheHandler.class);

    HttpCacheHandler() {
    }

    void flushAllPlugin(List<PluginData> pluginDataList) {
        if (CollectionUtils.isEmpty(pluginDataList)) {
            LOGGER.info("clear all plugin cache, old cache:{}", (Object)PLUGIN_MAP);
            PLUGIN_MAP.clear();
        } else {
            PLUGIN_MAP.clear();
            this.configPlugin(pluginDataList);
            pluginDataList.forEach(pluginData -> PLUGIN_MAP.put(pluginData.getName(), pluginData));
        }
    }

    void flushAllSelector(List<SelectorData> selectorDataList) {
        if (CollectionUtils.isEmpty(selectorDataList)) {
            LOGGER.info("clear all selector cache, old cache:{}", (Object)SELECTOR_MAP);
            SELECTOR_MAP.keySet().forEach(UpstreamCacheManager::removeByKey);
            SELECTOR_MAP.clear();
        } else {
            SELECTOR_MAP.values().forEach(selectors -> selectors.forEach(selector -> {
                if (PluginEnum.DIVIDE.getName().equals(selector.getPluginName())) {
                    UpstreamCacheManager.removeByKey(selector.getId());
                }
            }));
            UpstreamCacheManager.clear();
            selectorDataList.forEach(selector -> {
                if (PluginEnum.DIVIDE.getName().equals(selector.getPluginName())) {
                    UpstreamCacheManager.submit(selector);
                }
            });
            Map<String, List> pluginNameToSelectors = selectorDataList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SelectorData::getPluginName, Collectors.toCollection(ArrayList::new)));
            pluginNameToSelectors.keySet().forEach(pluginName -> {
                List sorted = ((List)pluginNameToSelectors.get(pluginName)).stream().sorted(Comparator.comparing(SelectorData::getSort)).collect(Collectors.toList());
                pluginNameToSelectors.put((String)pluginName, sorted);
            });
            SELECTOR_MAP.clear();
            SELECTOR_MAP.putAll(pluginNameToSelectors);
        }
    }

    void flushAllRule(List<RuleData> ruleDataList) {
        if (CollectionUtils.isEmpty(ruleDataList)) {
            LOGGER.info("clear all rule cache, old cache:{}", (Object)RULE_MAP);
            RULE_MAP.clear();
        } else {
            HystrixRefreshHandler.INS.refreshHystrix(ruleDataList);
            Map<String, List<RuleData>> selectorToRules = ruleDataList.stream().collect(Collectors.groupingBy(RuleData::getSelectorId));
            selectorToRules.keySet().forEach(selectorId -> {
                List sorted = ((List)selectorToRules.get(selectorId)).stream().sorted(Comparator.comparing(RuleData::getSort)).collect(Collectors.toList());
                selectorToRules.put((String)selectorId, sorted);
            });
            RULE_MAP.clear();
            RULE_MAP.putAll(selectorToRules);
        }
    }

    void flushAllAppAuth(List<AppAuthData> appAuthDataList) {
        if (CollectionUtils.isEmpty(appAuthDataList)) {
            LOGGER.info("clear all appAuth cache, old cache:{}", (Object)AUTH_MAP);
            AUTH_MAP.clear();
        } else {
            AUTH_MAP.clear();
            appAuthDataList.forEach(appAuth -> AUTH_MAP.put(appAuth.getAppKey(), appAuth));
        }
    }

    void flushMetaData(List<MetaData> metaDataList) {
        if (CollectionUtils.isEmpty(metaDataList)) {
            LOGGER.info("clear all metaDataList cache, old cache:{}", (Object)AUTH_MAP);
            META_DATA.clear();
        } else {
            this.initDubboRef(metaDataList);
            metaDataList.forEach(metaData -> META_DATA.put(metaData.getPath(), metaData));
        }
    }
}

