/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.concurrent.SoulThreadFactory;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.DivideUpstream;
import org.dromara.soul.common.utils.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class UpstreamCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpstreamCacheManager.class);
    private static final BlockingQueue<SelectorData> BLOCKING_QUEUE = new LinkedBlockingQueue<SelectorData>(1024);
    private static final Map<String, List<DivideUpstream>> UPSTREAM_MAP = Maps.newConcurrentMap();

    public List<DivideUpstream> findUpstreamListBySelectorId(String selectorId) {
        return UPSTREAM_MAP.get(selectorId);
    }

    static void removeByKey(String key) {
        UPSTREAM_MAP.remove(key);
    }

    @PostConstruct
    public void init() {
        new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), SoulThreadFactory.create((String)"save-upstream-task", (boolean)false)).execute(new Worker());
    }

    static void submit(SelectorData selectorData) {
        try {
            BLOCKING_QUEUE.put(selectorData);
        }
        catch (InterruptedException e) {
            LOGGER.error(e.getMessage());
        }
    }

    static void clear() {
        UPSTREAM_MAP.clear();
    }

    public void execute(SelectorData selectorData) {
        List upstreamList = GsonUtils.getInstance().fromList(selectorData.getHandle(), DivideUpstream.class);
        if (CollectionUtils.isNotEmpty((Collection)upstreamList)) {
            UPSTREAM_MAP.put(selectorData.getId(), upstreamList);
        } else {
            UPSTREAM_MAP.remove(selectorData.getId());
        }
    }

    class Worker
    implements Runnable {
        Worker() {
        }

        @Override
        public void run() {
            this.runTask();
        }

        private void runTask() {
            while (true) {
                try {
                    while (true) {
                        SelectorData selectorData = (SelectorData)BLOCKING_QUEUE.take();
                        Optional.of(selectorData).ifPresent(UpstreamCacheManager.this::execute);
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.warn("BLOCKING_QUEUE take operation was interrupted.", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

