/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.DataEventTypeEnum;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.web.cache.CommonCacheHandler;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.plugin.dubbo.ApplicationConfigCache;
import org.dromara.soul.web.plugin.hystrix.HystrixRefreshHandler;

class WebsocketCacheHandler
extends CommonCacheHandler {
    WebsocketCacheHandler() {
    }

    void handlePlugin(List<PluginData> pluginDataList, String eventType) {
        if (CollectionUtils.isNotEmpty(pluginDataList)) {
            DataEventTypeEnum eventTypeEnum = DataEventTypeEnum.acquireByName((String)eventType);
            switch (eventTypeEnum) {
                case REFRESH: 
                case MYSELF: {
                    PLUGIN_MAP.clear();
                    this.configPlugin(pluginDataList);
                    pluginDataList.forEach(e -> PLUGIN_MAP.put(e.getName(), e));
                    break;
                }
                case DELETE: {
                    pluginDataList.forEach(e -> {
                        PluginData cfr_ignored_0 = (PluginData)PLUGIN_MAP.remove(e.getName());
                    });
                }
                case UPDATE: 
                case CREATE: {
                    this.configPlugin(pluginDataList);
                    pluginDataList.forEach(e -> PLUGIN_MAP.put(e.getName(), e));
                    break;
                }
            }
        }
    }

    void handleSelector(List<SelectorData> selectorDataList, String eventType) {
        if (CollectionUtils.isNotEmpty(selectorDataList)) {
            DataEventTypeEnum eventTypeEnum = DataEventTypeEnum.acquireByName((String)eventType);
            switch (eventTypeEnum) {
                case REFRESH: 
                case MYSELF: {
                    SELECTOR_MAP.clear();
                    Map<String, List> allMap = selectorDataList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(SelectorData::getPluginName, Collectors.toCollection(ArrayList::new)));
                    SELECTOR_MAP.putAll(allMap);
                    UpstreamCacheManager.clear();
                    for (SelectorData selectorData : selectorDataList) {
                        if (!selectorData.getPluginName().equals(PluginEnum.DIVIDE.getName())) continue;
                        UpstreamCacheManager.submit(selectorData);
                    }
                    break;
                }
                case DELETE: {
                    selectorDataList.forEach(this::deleteSelectorData);
                    break;
                }
                case UPDATE: 
                case CREATE: {
                    selectorDataList.forEach(this::cacheSelectorData);
                    break;
                }
            }
        }
    }

    void handleRule(List<RuleData> ruleDataList, String eventType) {
        if (CollectionUtils.isNotEmpty(ruleDataList)) {
            DataEventTypeEnum eventTypeEnum = DataEventTypeEnum.acquireByName((String)eventType);
            switch (eventTypeEnum) {
                case REFRESH: 
                case MYSELF: {
                    RULE_MAP.clear();
                    Map<String, List> allMap = ruleDataList.stream().filter(Objects::nonNull).collect(Collectors.groupingBy(RuleData::getSelectorId, Collectors.toCollection(ArrayList::new)));
                    RULE_MAP.putAll(allMap);
                    break;
                }
                case DELETE: {
                    for (RuleData ruleData : ruleDataList) {
                        List existList = (List)RULE_MAP.get(ruleData.getSelectorId());
                        existList.removeIf(e -> e.getId().equals(ruleData.getId()));
                    }
                    break;
                }
                case UPDATE: 
                case CREATE: {
                    HystrixRefreshHandler.INS.refreshHystrix(ruleDataList);
                    ruleDataList.forEach(this::cacheRuleData);
                    break;
                }
            }
        }
    }

    void handleAppAuth(List<AppAuthData> appAuthDataList, String eventType) {
        if (CollectionUtils.isNotEmpty(appAuthDataList)) {
            DataEventTypeEnum eventTypeEnum = DataEventTypeEnum.acquireByName((String)eventType);
            switch (eventTypeEnum) {
                case REFRESH: 
                case MYSELF: {
                    AUTH_MAP.clear();
                    appAuthDataList.forEach(e -> AUTH_MAP.put(e.getAppKey(), e));
                    break;
                }
                case DELETE: {
                    appAuthDataList.forEach(e -> {
                        AppAuthData cfr_ignored_0 = (AppAuthData)AUTH_MAP.remove(e.getAppKey());
                    });
                }
                case UPDATE: 
                case CREATE: {
                    appAuthDataList.forEach(e -> AUTH_MAP.put(e.getAppKey(), e));
                    break;
                }
            }
        }
    }

    void handleMetaData(List<MetaData> metaDataList, String eventType) {
        if (CollectionUtils.isNotEmpty(metaDataList)) {
            DataEventTypeEnum eventTypeEnum = DataEventTypeEnum.acquireByName((String)eventType);
            switch (eventTypeEnum) {
                case REFRESH: 
                case MYSELF: {
                    this.initDubboRef(metaDataList);
                    metaDataList.forEach(e -> META_DATA.put(e.getPath(), e));
                    break;
                }
                case DELETE: {
                    metaDataList.forEach(e -> {
                        ApplicationConfigCache.getInstance().invalidate(e.getServiceName());
                        META_DATA.remove(e.getPath());
                    });
                    break;
                }
                case UPDATE: 
                case CREATE: {
                    this.initDubboRef(metaDataList);
                    metaDataList.forEach(e -> META_DATA.put(e.getPath(), e));
                    break;
                }
            }
        }
    }
}

