/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.filter.DubboBodyWebFilter;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.after.DubboResponsePlugin;
import org.dromara.soul.web.plugin.dubbo.DefaultGenericParamResolveServiceImpl;
import org.dromara.soul.web.plugin.dubbo.DubboProxyService;
import org.dromara.soul.web.plugin.dubbo.GenericParamResolveService;
import org.dromara.soul.web.plugin.function.DubboPlugin;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.web.server.WebFilter;

public class DubboConfiguration {
    @Bean
    @Order(value=20)
    public WebFilter dubboBodyWebFilter() {
        return new DubboBodyWebFilter();
    }

    @Bean
    @ConditionalOnMissingBean(value={GenericParamResolveService.class}, search=SearchStrategy.ALL)
    public GenericParamResolveService genericParamResolveService() {
        return new DefaultGenericParamResolveServiceImpl();
    }

    @Bean
    public SoulPlugin dubboPlugin(@Qualifier(value="localCacheManager") LocalCacheManager localCacheManager) {
        return new DubboPlugin(localCacheManager, new DubboProxyService(this.genericParamResolveService()));
    }

    @Bean
    public SoulPlugin dubboResponsePlugin() {
        return new DubboResponsePlugin();
    }
}

