/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.security.cert.X509Certificate;
import org.dromara.soul.web.config.HttpClientProperties;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.after.NettyClientResponsePlugin;
import org.dromara.soul.web.plugin.after.WebClientResponsePlugin;
import org.dromara.soul.web.plugin.http.NettyHttpClientPlugin;
import org.dromara.soul.web.plugin.http.WebClientPlugin;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.tcp.ProxyProvider;

public class HttpClientConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HttpClient httpClient(HttpClientProperties properties) {
        HttpClientProperties.Pool pool = properties.getPool();
        ConnectionProvider connectionProvider = pool.getType() == HttpClientProperties.Pool.PoolType.DISABLED ? ConnectionProvider.newConnection() : (pool.getType() == HttpClientProperties.Pool.PoolType.FIXED ? ConnectionProvider.fixed((String)pool.getName(), (int)pool.getMaxConnections(), (long)pool.getAcquireTimeout()) : ConnectionProvider.elastic((String)pool.getName()));
        HttpClient httpClient = HttpClient.create((ConnectionProvider)connectionProvider).tcpConfiguration(tcpClient -> {
            HttpClientProperties.Proxy proxy;
            if (properties.getConnectTimeout() != null) {
                tcpClient = tcpClient.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)properties.getConnectTimeout());
            }
            if (StringUtils.hasText((String)(proxy = properties.getProxy()).getHost())) {
                tcpClient = tcpClient.proxy(proxySpec -> {
                    ProxyProvider.Builder builder = proxySpec.type(ProxyProvider.Proxy.HTTP).host(proxy.getHost());
                    PropertyMapper map = PropertyMapper.get();
                    map.from(proxy::getPort).whenNonNull().to(arg_0 -> ((ProxyProvider.Builder)builder).port(arg_0));
                    map.from(proxy::getUsername).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).username(arg_0));
                    map.from(proxy::getPassword).whenHasText().to(password -> builder.password(s -> password));
                    map.from(proxy::getNonProxyHostsPattern).whenHasText().to(arg_0 -> ((ProxyProvider.Builder)builder).nonProxyHosts(arg_0));
                });
            }
            return tcpClient;
        });
        HttpClientProperties.Ssl ssl = properties.getSsl();
        if (ssl.getTrustedX509CertificatesForTrustManager().length > 0 || ssl.isUseInsecureTrustManager()) {
            httpClient = httpClient.secure(sslContextSpec -> {
                SslContextBuilder sslContextBuilder = SslContextBuilder.forClient();
                X509Certificate[] trustedX509Certificates = ssl.getTrustedX509CertificatesForTrustManager();
                if (trustedX509Certificates.length > 0) {
                    sslContextBuilder.trustManager(trustedX509Certificates);
                } else if (ssl.isUseInsecureTrustManager()) {
                    sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                sslContextSpec.sslContext(sslContextBuilder).defaultConfiguration(ssl.getDefaultConfigurationType()).handshakeTimeout(ssl.getHandshakeTimeout()).closeNotifyFlushTimeout(ssl.getCloseNotifyFlushTimeout()).closeNotifyReadTimeout(ssl.getCloseNotifyReadTimeout());
            });
        }
        if (properties.isWiretap()) {
            httpClient = httpClient.wiretap(true);
        }
        return httpClient;
    }

    @Configuration
    @ConditionalOnProperty(name={"soul.httpclient.strategy"}, havingValue="netty")
    static class NettyHttpClientConfiguration {
        NettyHttpClientConfiguration() {
        }

        @Bean
        public SoulPlugin nettyHttpClientPlugin(HttpClient httpClient) {
            return new NettyHttpClientPlugin(httpClient);
        }

        @Bean
        public SoulPlugin nettyClientResponsePlugin() {
            return new NettyClientResponsePlugin();
        }
    }

    @Configuration
    @ConditionalOnProperty(name={"soul.httpclient.strategy"}, havingValue="webClient", matchIfMissing=true)
    static class WebClientConfiguration {
        WebClientConfiguration() {
        }

        @Bean
        public SoulPlugin webClientPlugin(HttpClient httpClient) {
            WebClient webClient = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build();
            return new WebClientPlugin(webClient);
        }

        @Bean
        public SoulPlugin webClientResponsePlugin() {
            return new WebClientResponsePlugin();
        }
    }
}

