/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import java.util.List;
import java.util.stream.Collectors;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.cache.UpstreamCacheManager;
import org.dromara.soul.web.config.HttpClientProperties;
import org.dromara.soul.web.config.SoulConfig;
import org.dromara.soul.web.configuration.DubboConfiguration;
import org.dromara.soul.web.configuration.ErrorHandlerConfiguration;
import org.dromara.soul.web.configuration.HttpClientConfiguration;
import org.dromara.soul.web.configuration.LocalCacheConfiguration;
import org.dromara.soul.web.configuration.SoulExtConfiguration;
import org.dromara.soul.web.configuration.SpringExtConfiguration;
import org.dromara.soul.web.disruptor.publisher.SoulEventPublisher;
import org.dromara.soul.web.filter.FileSizeFilter;
import org.dromara.soul.web.filter.ParamService;
import org.dromara.soul.web.filter.ParamWebFilter;
import org.dromara.soul.web.filter.TimeWebFilter;
import org.dromara.soul.web.filter.WebSocketWebFilter;
import org.dromara.soul.web.handler.SoulWebHandler;
import org.dromara.soul.web.influxdb.service.InfluxDbService;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.before.DefaultSignService;
import org.dromara.soul.web.plugin.before.GlobalPlugin;
import org.dromara.soul.web.plugin.before.SignPlugin;
import org.dromara.soul.web.plugin.before.SignService;
import org.dromara.soul.web.plugin.before.WafPlugin;
import org.dromara.soul.web.plugin.function.DividePlugin;
import org.dromara.soul.web.plugin.function.RateLimiterPlugin;
import org.dromara.soul.web.plugin.function.RewritePlugin;
import org.dromara.soul.web.plugin.function.WebSocketPlugin;
import org.dromara.soul.web.plugin.hystrix.HystrixPlugin;
import org.dromara.soul.web.plugin.montior.MonitorPlugin;
import org.dromara.soul.web.plugin.ratelimter.RedisRateLimiter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.web.reactive.socket.client.ReactorNettyWebSocketClient;
import org.springframework.web.reactive.socket.client.WebSocketClient;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.server.WebFilter;

@Configuration
@ComponentScan(value={"org.dromara.soul"})
@Import(value={DubboConfiguration.class, LocalCacheConfiguration.class, ErrorHandlerConfiguration.class, SoulExtConfiguration.class, HttpClientConfiguration.class, SpringExtConfiguration.class})
@EnableConfigurationProperties(value={HttpClientProperties.class})
public class SoulConfiguration {
    private final LocalCacheManager localCacheManager;
    private final UpstreamCacheManager upstreamCacheManager;

    @Autowired(required=false)
    public SoulConfiguration(@Qualifier(value="localCacheManager") LocalCacheManager localCacheManager, UpstreamCacheManager upstreamCacheManager) {
        this.localCacheManager = localCacheManager;
        this.upstreamCacheManager = upstreamCacheManager;
    }

    @Bean
    public SoulPlugin globalPlugin() {
        return new GlobalPlugin();
    }

    @Bean
    public SoulPlugin signPlugin(SignService signService) {
        return new SignPlugin(signService);
    }

    @Bean
    @ConditionalOnMissingBean(value={SignService.class})
    public SignService signService() {
        return new DefaultSignService(this.localCacheManager);
    }

    @Bean
    public SoulPlugin wafPlugin() {
        return new WafPlugin(this.localCacheManager);
    }

    @Bean
    public SoulPlugin rateLimiterPlugin() {
        return new RateLimiterPlugin(this.localCacheManager, this.redisRateLimiter());
    }

    @Bean
    @ConditionalOnMissingBean
    public RedisRateLimiter redisRateLimiter() {
        return new RedisRateLimiter();
    }

    @Bean
    public SoulPlugin rewritePlugin() {
        return new RewritePlugin(this.localCacheManager);
    }

    @Bean
    public SoulPlugin hystrixPlugin() {
        return new HystrixPlugin(this.localCacheManager);
    }

    @Bean
    public SoulPlugin dividePlugin() {
        return new DividePlugin(this.localCacheManager, this.upstreamCacheManager);
    }

    @Bean
    public WebSocketPlugin webSocketPlugin(WebSocketClient webSocketClient, WebSocketService webSocketService) {
        return new WebSocketPlugin(this.localCacheManager, this.upstreamCacheManager, webSocketClient, webSocketService);
    }

    @Bean
    public InfluxDbService influxDbService() {
        return new InfluxDbService();
    }

    @Bean
    public SoulEventPublisher soulEventPublisher(InfluxDbService influxDbService) {
        return new SoulEventPublisher(influxDbService);
    }

    @Bean
    public SoulPlugin monitorPlugin(SoulEventPublisher soulEventPublisher) {
        return new MonitorPlugin(soulEventPublisher, this.localCacheManager);
    }

    @Bean(value={"webHandler"})
    public SoulWebHandler soulWebHandler(List<SoulPlugin> plugins) {
        List<SoulPlugin> soulPlugins = plugins.stream().sorted((m, n) -> {
            if (m.pluginType().equals((Object)n.pluginType())) {
                return m.getOrder() - n.getOrder();
            }
            return m.pluginType().getName().compareTo(n.pluginType().getName());
        }).collect(Collectors.toList());
        return new SoulWebHandler(soulPlugins);
    }

    @Bean
    @Order(value=-10)
    public WebFilter bodySizeFilter() {
        return new FileSizeFilter();
    }

    @Bean
    @Order(value=1)
    public WebFilter paramWebFilter(ParamService paramService) {
        return new ParamWebFilter(paramService);
    }

    @Bean
    @Order(value=30)
    @ConditionalOnProperty(name={"soul.filterTimeEnable"})
    public WebFilter timeWebFilter(SoulConfig soulConfig) {
        return new TimeWebFilter(soulConfig);
    }

    @Bean
    @Order(value=4)
    public WebFilter webSocketWebFilter() {
        return new WebSocketWebFilter();
    }

    @Bean
    public ReactorNettyWebSocketClient reactorNettyWebSocketClient() {
        return new ReactorNettyWebSocketClient();
    }

    @Bean
    public WebSocketService webSocketService() {
        return new HandshakeWebSocketService();
    }
}

