/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.configuration;

import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.configuration.LocalCacheConfiguration;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.function.SpringCloudPlugin;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.netflix.ribbon.RibbonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.DispatcherHandler;

@ConditionalOnClass(value={LoadBalancerClient.class, RibbonAutoConfiguration.class, DispatcherHandler.class})
@AutoConfigureAfter(value={RibbonAutoConfiguration.class, LocalCacheConfiguration.class})
@ConditionalOnBean(value={LoadBalancerClient.class})
@EnableDiscoveryClient
@Configuration
public class SpringCloudConfiguration {
    @Bean
    public SoulPlugin springCloudPlugin(LoadBalancerClient loadBalancerClient, @Qualifier(value="localCacheManager") LocalCacheManager localCacheManager) {
        return new SpringCloudPlugin(localCacheManager, loadBalancerClient);
    }
}

