/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.handler;

import java.util.List;
import java.util.Objects;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public final class SoulWebHandler
implements WebHandler {
    private List<SoulPlugin> plugins;
    private Scheduler scheduler;

    public SoulWebHandler(List<SoulPlugin> plugins) {
        this.plugins = plugins;
        String schedulerType = System.getProperty("soul.scheduler.type", "fixed");
        if (Objects.equals(schedulerType, "fixed")) {
            int threads = Integer.parseInt(System.getProperty("soul.work.threads", "" + Math.max((Runtime.getRuntime().availableProcessors() << 1) + 1, 16)));
            this.scheduler = Schedulers.newParallel((String)"soul-work-threads", (int)threads);
        } else {
            this.scheduler = Schedulers.elastic();
        }
    }

    public Mono<Void> handle(ServerWebExchange exchange) {
        return new DefaultSoulPluginChain(this.plugins).execute(exchange).subscribeOn(this.scheduler);
    }

    private static class DefaultSoulPluginChain
    implements SoulPluginChain {
        private int index;
        private final List<SoulPlugin> plugins;

        DefaultSoulPluginChain(List<SoulPlugin> plugins) {
            this.plugins = plugins;
        }

        @Override
        public Mono<Void> execute(ServerWebExchange exchange) {
            return Mono.defer(() -> {
                if (this.index < this.plugins.size()) {
                    SoulPlugin plugin;
                    Boolean skip;
                    if ((skip = (plugin = this.plugins.get(this.index++)).skip(exchange)).booleanValue()) {
                        return this.execute(exchange);
                    }
                    return plugin.execute(exchange, this);
                }
                return Mono.empty();
            });
        }
    }
}

