/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.SelectorTypeEnum;
import org.dromara.soul.common.utils.LogUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.condition.strategy.MatchStrategyUtils;
import org.dromara.soul.web.plugin.SoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractSoulPlugin
implements SoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSoulPlugin.class);
    private final LocalCacheManager localCacheManager;

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, SoulPluginChain var2, SelectorData var3, RuleData var4);

    @Override
    public Mono<Void> execute(ServerWebExchange exchange, SoulPluginChain chain) {
        String pluginName = this.named();
        PluginData pluginData = this.localCacheManager.findPluginByName(pluginName);
        if (pluginData != null && pluginData.getEnabled().booleanValue()) {
            List<RuleData> rules;
            RequestDTO request = (RequestDTO)exchange.getAttribute("requestDTO");
            List<SelectorData> selectors = this.localCacheManager.findSelectorByPluginName(this.named());
            if (CollectionUtils.isEmpty(selectors)) {
                LOGGER.error("can not find selector data :{},params:{}", (Object)pluginName, (Object)Objects.requireNonNull(request).toString());
                Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_FIND_SELECTOR.getCode(), SoulResultEnum.CANNOT_FIND_SELECTOR.getMsg(), null);
                return SoulResultUtils.result(exchange, error);
            }
            SelectorData selectorData = selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, exchange) != false).findFirst().orElse(null);
            if (Objects.isNull(selectorData)) {
                if (PluginEnum.DIVIDE.getName().equals(pluginName) || PluginEnum.DUBBO.getName().equals(pluginName) || PluginEnum.SPRING_CLOUD.getName().equals(pluginName)) {
                    LOGGER.error("can not match selector data :{},params:{}", (Object)pluginName, (Object)Objects.requireNonNull(request).toString());
                    Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_FIND_SELECTOR.getCode(), SoulResultEnum.CANNOT_FIND_SELECTOR.getMsg(), null);
                    return SoulResultUtils.result(exchange, error);
                }
                return chain.execute(exchange);
            }
            if (selectorData.getLoged().booleanValue()) {
                LogUtils.info((Logger)LOGGER, (String)(this.named() + " selector success selector name :{}"), () -> ((SelectorData)selectorData).getName());
            }
            if (CollectionUtils.isEmpty(rules = this.localCacheManager.findRuleBySelectorId(selectorData.getId()))) {
                LOGGER.error("can not match rule data :{},params:{}", (Object)this.named(), (Object)Objects.requireNonNull(request).toString());
                return chain.execute(exchange);
            }
            RuleData rule = selectorData.getType().intValue() == SelectorTypeEnum.FULL_FLOW.getCode() ? rules.get(rules.size() - 1) : this.filterRule(exchange, rules);
            if (Objects.isNull(rule)) {
                if (PluginEnum.DIVIDE.getName().equals(pluginName) || PluginEnum.DUBBO.getName().equals(pluginName) || PluginEnum.SPRING_CLOUD.getName().equals(pluginName)) {
                    LOGGER.error(Objects.requireNonNull(request).getModule() + ":" + request.getMethod() + " not match  " + pluginName + "  rule");
                    Object error = SoulResultWarp.error(SoulResultEnum.RULE_NOT_FIND.getCode(), SoulResultEnum.RULE_NOT_FIND.getMsg(), null);
                    return SoulResultUtils.result(exchange, error);
                }
                return chain.execute(exchange);
            }
            if (rule.getLoged().booleanValue()) {
                LogUtils.info((Logger)LOGGER, () -> Objects.requireNonNull(request).getModule() + ":" + request.getMethod() + " match " + this.named() + " rule is name :" + rule.getName());
            }
            return this.doExecute(exchange, chain, selectorData, rule);
        }
        return chain.execute(exchange);
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyUtils.match(selector.getMatchMode(), selector.getConditionList(), exchange);
        }
        return true;
    }

    private RuleData filterRule(ServerWebExchange exchange, List<RuleData> rules) {
        return rules.stream().filter(rule -> Objects.nonNull(rule) && rule.getEnabled() != false).filter(ruleData -> MatchStrategyUtils.match(ruleData.getMatchMode(), ruleData.getConditionDataList(), exchange)).findFirst().orElse(null);
    }

    public AbstractSoulPlugin(LocalCacheManager localCacheManager) {
        this.localCacheManager = localCacheManager;
    }
}

