/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.before;

import com.alibaba.dubbo.rpc.RpcContext;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.dromara.soul.common.dto.AppAuthData;
import org.dromara.soul.common.dto.AuthParamData;
import org.dromara.soul.common.dto.AuthPathData;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.DateUtils;
import org.dromara.soul.common.utils.SignUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.before.SignService;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.server.ServerWebExchange;

public class DefaultSignService
implements SignService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSignService.class);
    private final LocalCacheManager localCacheManager;
    @Value(value="${soul.sign.delay:5}")
    private int delay;

    public DefaultSignService(LocalCacheManager localCacheManager) {
        this.localCacheManager = localCacheManager;
    }

    @Override
    public Pair<Boolean, String> signVerify(RequestDTO requestDTO, ServerWebExchange exchange) {
        PluginData signData = this.localCacheManager.findPluginByName(PluginEnum.SIGN.getName());
        if (signData != null && signData.getEnabled().booleanValue()) {
            return this.verify(requestDTO, exchange);
        }
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    private Pair<Boolean, String> verify(RequestDTO requestDTO, ServerWebExchange exchange) {
        LocalDateTime now;
        if (StringUtils.isBlank((CharSequence)requestDTO.getAppKey()) || StringUtils.isBlank((CharSequence)requestDTO.getSign()) || StringUtils.isBlank((CharSequence)requestDTO.getTimestamp())) {
            LOGGER.error("\u8ba4\u8bc1\u53c2\u6570\u4e0d\u5b8c\u6574,{}", (Object)requestDTO);
            return Pair.of((Object)Boolean.FALSE, (Object)"\u8ba4\u8bc1\u53c2\u6570\u4f20\u5165\u4e0d\u5b8c\u6574!");
        }
        LocalDateTime start = DateUtils.formatLocalDateTimeFromTimestamp((Long)Long.parseLong(requestDTO.getTimestamp()));
        long between = DateUtils.acquireMinutesBetween((LocalDateTime)start, (LocalDateTime)(now = LocalDateTime.now()));
        if (between > (long)this.delay) {
            return Pair.of((Object)Boolean.FALSE, (Object)String.format(SoulResultEnum.SING_TIME_IS_TIMEOUT.getMsg(), this.delay));
        }
        return this.sign(requestDTO, exchange);
    }

    private Pair<Boolean, String> sign(RequestDTO requestDTO, ServerWebExchange exchange) {
        AppAuthData appAuthData = this.localCacheManager.findAuthDataByAppKey(requestDTO.getAppKey());
        if (Objects.isNull(appAuthData) || !appAuthData.getEnabled().booleanValue()) {
            LOGGER.error("\u8ba4\u8bc1APP_kEY\u4e0d\u5b58\u5728,\u6216\u8005\u5df2\u7ecf\u88ab\u7981\u7528,{}", (Object)requestDTO.getAppKey());
            return Pair.of((Object)Boolean.FALSE, (Object)"\u8ba4\u8bc1\u7b7e\u540dAPP_KEY,\u4e0d\u5b58\u5728");
        }
        List pathDataList = appAuthData.getPathDataList();
        if (CollectionUtils.isEmpty((Collection)pathDataList)) {
            LOGGER.error("\u60a8\u5c1a\u672a\u914d\u7f6e\u8def\u5f84:{}", (Object)requestDTO.getAppKey());
            return Pair.of((Object)Boolean.FALSE, (Object)"\u8ba4\u8bc1Key\u672a\u914d\u7f6e\u8def\u5f84\u83b7\u53d6\u672a\u5339\u914d");
        }
        boolean match = pathDataList.stream().filter(AuthPathData::getEnabled).anyMatch(e -> e.getPath().equals(requestDTO.getPath()));
        if (!match) {
            LOGGER.error("\u60a8\u5c1a\u672a\u914d\u7f6e\u8def\u5f84:{},{}", (Object)requestDTO.getAppKey(), (Object)requestDTO.getRealUrl());
            return Pair.of((Object)Boolean.FALSE, (Object)"\u8ba4\u8bc1Key\u672a\u914d\u7f6e\u8def\u5f84\u83b7\u53d6\u672a\u5339\u914d");
        }
        String sigKey = SignUtils.generateSign((String)appAuthData.getAppSecret(), this.buildParamsMap(requestDTO));
        boolean result = Objects.equals(sigKey, requestDTO.getSign());
        if (!result) {
            LOGGER.error("\u7b7e\u540d\u63d2\u4ef6\u5f97\u5230\u7684\u7b7e\u540d\u4e3a:{},\u4f20\u5165\u7684\u7b7e\u540d\u503c\u4e3a:{}", (Object)sigKey, (Object)requestDTO.getSign());
            return Pair.of((Object)Boolean.FALSE, (Object)"\u7b7e\u540d\u503c\u9519\u8bef\uff01");
        }
        List paramDataList = appAuthData.getParamDataList();
        if (CollectionUtils.isEmpty((Collection)paramDataList)) {
            return Pair.of((Object)Boolean.TRUE, (Object)"");
        }
        paramDataList.stream().filter(p -> ("/" + p.getAppName()).equals(requestDTO.getContextPath())).map(AuthParamData::getAppParam).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).findFirst().ifPresent(param -> {
            if (RpcTypeEnum.HTTP.getName().equals(requestDTO.getRpcType())) {
                exchange.getRequest().mutate().headers(httpHeaders -> httpHeaders.set("appParam", param)).build();
            } else if (RpcTypeEnum.DUBBO.getName().equals(requestDTO.getRpcType())) {
                RpcContext.getContext().setAttachment("appParam", param);
            }
        });
        return Pair.of((Object)Boolean.TRUE, (Object)"");
    }

    private Map<String, String> buildParamsMap(RequestDTO dto) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        map.put("timestamp", dto.getTimestamp());
        map.put("path", dto.getPath());
        map.put("version", "1.0.0");
        return map;
    }
}

