/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.config;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.dromara.soul.common.config.DubboRegisterConfig;
import org.dromara.soul.common.config.MonitorConfig;
import org.dromara.soul.common.config.RateLimiterConfig;
import org.dromara.soul.common.dto.PluginData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.RedisModeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.plugin.config.Singleton;
import org.dromara.soul.web.plugin.dubbo.ApplicationConfigCache;
import org.springframework.data.influxdb.InfluxDBConnectionFactory;
import org.springframework.data.influxdb.InfluxDBProperties;
import org.springframework.data.influxdb.InfluxDBTemplate;
import org.springframework.data.influxdb.converter.PointCollectionConverter;
import org.springframework.data.influxdb.converter.PointConverter;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class PluginConfigHandler
extends Enum<PluginConfigHandler> {
    public static final /* enum */ PluginConfigHandler INS = new PluginConfigHandler();
    private static final /* synthetic */ PluginConfigHandler[] $VALUES;

    public static PluginConfigHandler[] values() {
        return (PluginConfigHandler[])$VALUES.clone();
    }

    public static PluginConfigHandler valueOf(String name) {
        return Enum.valueOf(PluginConfigHandler.class, name);
    }

    public void initPluginConfig(List<PluginData> pluginDataList) {
        pluginDataList.stream().filter(PluginData::getEnabled).forEach(pluginData -> {
            if (PluginEnum.MONITOR.getName().equals(pluginData.getName())) {
                MonitorConfig monitorConfig = (MonitorConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), MonitorConfig.class);
                if (Objects.isNull(Singleton.INST.get(InfluxDBTemplate.class)) || Objects.isNull(Singleton.INST.get(MonitorConfig.class)) || !monitorConfig.equals((Object)Singleton.INST.get(MonitorConfig.class))) {
                    InfluxDBConnectionFactory connectionFactory = new InfluxDBConnectionFactory(this.buildByConfig(monitorConfig));
                    InfluxDBTemplate influxDBTemplate = new InfluxDBTemplate(connectionFactory, (PointCollectionConverter)new PointConverter());
                    Singleton.INST.single(InfluxDBTemplate.class, influxDBTemplate);
                    Singleton.INST.single(MonitorConfig.class, monitorConfig);
                }
            } else if (PluginEnum.RATE_LIMITER.getName().equals(pluginData.getName())) {
                RateLimiterConfig rateLimiterConfig = (RateLimiterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), RateLimiterConfig.class);
                if (Objects.isNull(Singleton.INST.get(ReactiveRedisTemplate.class)) || Objects.isNull(Singleton.INST.get(RateLimiterConfig.class)) || !rateLimiterConfig.equals((Object)Singleton.INST.get(RateLimiterConfig.class))) {
                    LettuceConnectionFactory lettuceConnectionFactory = this.createLettuceConnectionFactory(rateLimiterConfig);
                    lettuceConnectionFactory.afterPropertiesSet();
                    StringRedisSerializer serializer = new StringRedisSerializer();
                    RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key((RedisSerializer)serializer).value((RedisSerializer)serializer).hashKey((RedisSerializer)serializer).hashValue((RedisSerializer)serializer).build();
                    ReactiveRedisTemplate reactiveRedisTemplate = new ReactiveRedisTemplate((ReactiveRedisConnectionFactory)lettuceConnectionFactory, serializationContext);
                    Singleton.INST.single(ReactiveRedisTemplate.class, reactiveRedisTemplate);
                    Singleton.INST.single(RateLimiterConfig.class, rateLimiterConfig);
                }
            } else if (PluginEnum.DUBBO.getName().equals(pluginData.getName())) {
                DubboRegisterConfig dubboRegisterConfig = (DubboRegisterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), DubboRegisterConfig.class);
                DubboRegisterConfig exist = Singleton.INST.get(DubboRegisterConfig.class);
                if (Objects.nonNull(dubboRegisterConfig)) {
                    if (Objects.isNull(exist) || !dubboRegisterConfig.equals((Object)exist)) {
                        ApplicationConfigCache.getInstance().init(dubboRegisterConfig.getRegister());
                        ApplicationConfigCache.getInstance().invalidateAll();
                    }
                    Singleton.INST.single(DubboRegisterConfig.class, dubboRegisterConfig);
                }
            }
        });
    }

    private LettuceConnectionFactory createLettuceConnectionFactory(RateLimiterConfig rateLimiterConfig) {
        LettuceClientConfiguration lettuceClientConfiguration = this.getLettuceClientConfiguration(rateLimiterConfig);
        if (RedisModeEnum.SENTINEL.getName().equals(rateLimiterConfig.getMode())) {
            return new LettuceConnectionFactory(this.redisSentinelConfiguration(rateLimiterConfig), lettuceClientConfiguration);
        }
        if (RedisModeEnum.CLUSTER.getName().equals(rateLimiterConfig.getMode())) {
            return new LettuceConnectionFactory(this.redisClusterConfiguration(rateLimiterConfig), lettuceClientConfiguration);
        }
        return new LettuceConnectionFactory(this.redisStandaloneConfiguration(rateLimiterConfig), lettuceClientConfiguration);
    }

    private LettuceClientConfiguration getLettuceClientConfiguration(RateLimiterConfig rateLimiterConfig) {
        return LettucePoolingClientConfiguration.builder().poolConfig(this.getPoolConfig(rateLimiterConfig)).build();
    }

    private GenericObjectPoolConfig<?> getPoolConfig(RateLimiterConfig rateLimiterConfig) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(rateLimiterConfig.getMaxActive());
        config.setMaxIdle(rateLimiterConfig.getMaxIdle());
        config.setMinIdle(rateLimiterConfig.getMinIdle());
        if (rateLimiterConfig.getMaxWait() != null) {
            config.setMaxWaitMillis(rateLimiterConfig.getMaxWait().toMillis());
        }
        return config;
    }

    protected final RedisStandaloneConfiguration redisStandaloneConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        String[] parts = StringUtils.split((String)rateLimiterConfig.getUrl(), (String)":");
        assert (parts != null);
        config.setHostName(parts[0]);
        config.setPort(Integer.parseInt(parts[1]));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        config.setDatabase(rateLimiterConfig.getDatabase().intValue());
        return config;
    }

    private RedisClusterConfiguration redisClusterConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisClusterConfiguration config = new RedisClusterConfiguration();
        config.setClusterNodes(this.createRedisNode(rateLimiterConfig.getUrl()));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        return config;
    }

    private RedisSentinelConfiguration redisSentinelConfiguration(RateLimiterConfig rateLimiterConfig) {
        RedisSentinelConfiguration config = new RedisSentinelConfiguration();
        config.master(rateLimiterConfig.getMaster());
        config.setSentinels(this.createRedisNode(rateLimiterConfig.getUrl()));
        if (rateLimiterConfig.getPassword() != null) {
            config.setPassword(RedisPassword.of((String)rateLimiterConfig.getPassword()));
        }
        config.setDatabase(rateLimiterConfig.getDatabase().intValue());
        return config;
    }

    private List<RedisNode> createRedisNode(String url) {
        ArrayList<RedisNode> redisNodes = new ArrayList<RedisNode>();
        ArrayList nodes = Lists.newArrayList((Iterable)Splitter.on((String)";").split((CharSequence)url));
        for (String node : nodes) {
            try {
                String[] parts = StringUtils.split((String)node, (String)":");
                Assert.state((Objects.requireNonNull(parts).length == 2 ? 1 : 0) != 0, (String)"Must be defined as 'host:port'");
                redisNodes.add(new RedisNode(parts[0], Integer.parseInt(parts[1])));
            }
            catch (RuntimeException ex) {
                throw new IllegalStateException("Invalid redis sentinel property '" + node + "'", ex);
            }
        }
        return redisNodes;
    }

    private InfluxDBProperties buildByConfig(MonitorConfig monitorConfig) {
        InfluxDBProperties influxDBProperties = new InfluxDBProperties();
        influxDBProperties.setDatabase(monitorConfig.getDatabase());
        influxDBProperties.setUrl(monitorConfig.getUrl());
        influxDBProperties.setUsername(monitorConfig.getUserName());
        influxDBProperties.setPassword(monitorConfig.getPassword());
        influxDBProperties.setConnectTimeout(monitorConfig.getConnectTimeout().intValue());
        influxDBProperties.setReadTimeout(monitorConfig.getReadTimeout().intValue());
        influxDBProperties.setRetentionPolicy(monitorConfig.getRetentionPolicy());
        influxDBProperties.setWriteTimeout(monitorConfig.getWriteTimeout().intValue());
        influxDBProperties.setGzip(monitorConfig.getGzip().booleanValue());
        return influxDBProperties;
    }

    static {
        $VALUES = new PluginConfigHandler[]{INS};
    }
}

