/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.dubbo;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.service.GenericService;
import org.dromara.soul.common.dto.MetaData;
import org.dromara.soul.common.enums.LoadBalanceEnum;
import org.dromara.soul.common.exception.SoulException;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.plugin.dubbo.DubboParamExt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationConfigCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfigCache.class);
    private ApplicationConfig applicationConfig;
    private RegistryConfig registryConfig;
    private final int maxCount = 50000;
    private final LoadingCache<String, ReferenceConfig<GenericService>> cache = CacheBuilder.newBuilder().maximumWeight(50000L).weigher((string, ReferenceConfig2) -> this.getSize()).removalListener(notification -> {
        ReferenceConfig config = (ReferenceConfig)notification.getValue();
        if (config != null) {
            try {
                Class<?> cz = config.getClass();
                Field field = cz.getDeclaredField("ref");
                field.setAccessible(true);
                field.set(config, null);
            }
            catch (Exception e) {
                LOG.error("\u4fee\u6539ref\u4e3anull", (Throwable)e);
            }
        }
    }).build((CacheLoader)new CacheLoader<String, ReferenceConfig<GenericService>>(){

        public ReferenceConfig<GenericService> load(String key) {
            return new ReferenceConfig();
        }
    });

    private ApplicationConfigCache() {
    }

    private int getSize() {
        return (int)this.cache.size();
    }

    public static ApplicationConfigCache getInstance() {
        return ApplicationConfigCacheInstance.INSTANCE;
    }

    public void init(String register) {
        if (this.applicationConfig == null) {
            this.applicationConfig = new ApplicationConfig("soul_proxy");
        }
        if (this.registryConfig == null) {
            this.registryConfig = new RegistryConfig();
            this.registryConfig.setProtocol("dubbo");
            this.registryConfig.setId("soul_proxy");
            this.registryConfig.setRegister(Boolean.valueOf(false));
            this.registryConfig.setAddress(register);
        }
    }

    public ReferenceConfig<GenericService> initRef(MetaData metaData) {
        try {
            ReferenceConfig referenceConfig = (ReferenceConfig)this.cache.get((Object)metaData.getServiceName());
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{referenceConfig.getInterface()})) {
                return referenceConfig;
            }
        }
        catch (Exception e) {
            LOG.error("init dubbo ref ex:{}", (Object)e.getMessage());
        }
        return this.build(metaData);
    }

    public ReferenceConfig<GenericService> build(MetaData metaData) {
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric(Boolean.valueOf(true));
        reference.setApplication(this.applicationConfig);
        reference.setRegistry(this.registryConfig);
        reference.setInterface(metaData.getServiceName());
        reference.setProtocol("dubbo");
        String rpcExt = metaData.getRpcExt();
        try {
            DubboParamExt dubboParamExt = (DubboParamExt)GsonUtils.getInstance().fromJson(rpcExt, DubboParamExt.class);
            if (Objects.nonNull(dubboParamExt)) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExt.getVersion()})) {
                    reference.setVersion(dubboParamExt.getVersion());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExt.getGroup()})) {
                    reference.setGroup(dubboParamExt.getGroup());
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{dubboParamExt.getLoadbalance()})) {
                    String loadBalance = dubboParamExt.getLoadbalance();
                    if (LoadBalanceEnum.HASH.getName().equals(loadBalance) || "consistenthash".equals(loadBalance)) {
                        reference.setLoadbalance("consistenthash");
                    } else if (LoadBalanceEnum.ROUND_ROBIN.getName().equals(loadBalance)) {
                        reference.setLoadbalance("roundrobin");
                    } else {
                        reference.setLoadbalance(loadBalance);
                    }
                }
                Optional.ofNullable(dubboParamExt.getTimeout()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setTimeout(arg_0));
                Optional.ofNullable(dubboParamExt.getRetries()).ifPresent(arg_0 -> ((ReferenceConfig)reference).setRetries(arg_0));
            }
        }
        catch (Exception e) {
            LOG.error("rpc \u6269\u5c55\u53c2\u6570\u8f6c\u6210json\u5f02\u5e38,{}", (Object)metaData);
        }
        try {
            Object obj = reference.get();
            if (obj != null) {
                LOG.info("\u521d\u59cb\u5316\u5f15\u7528\u6210\u529f{}", (Object)metaData);
                this.cache.put((Object)metaData.getServiceName(), (Object)reference);
            }
        }
        catch (Exception ex) {
            LOG.error("\u521d\u59cb\u5316\u5f15\u7528\u6ca1\u6709\u627e\u5230\u63d0\u4f9b\u8005\u3010{}\u3011,ex:{}", (Object)metaData, (Object)ex.getMessage());
        }
        return reference;
    }

    public <T> ReferenceConfig<T> get(String serviceName) {
        try {
            return (ReferenceConfig)this.cache.get((Object)serviceName);
        }
        catch (ExecutionException e) {
            throw new SoulException(e.getCause());
        }
    }

    public void invalidate(String serviceName) {
        try {
            this.cache.invalidate((Object)serviceName);
        }
        catch (Exception e) {
            throw new SoulException(e.getCause());
        }
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    static class ApplicationConfigCacheInstance {
        static final ApplicationConfigCache INSTANCE = new ApplicationConfigCache();

        ApplicationConfigCacheInstance() {
        }
    }
}

