/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.function;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.rule.SpringCloudRuleHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.RpcTypeEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.dromara.soul.web.result.SoulResultEnum;
import org.dromara.soul.web.result.SoulResultUtils;
import org.dromara.soul.web.result.SoulResultWarp;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SpringCloudPlugin
extends AbstractSoulPlugin {
    private final LoadBalancerClient loadBalancer;

    public SpringCloudPlugin(LocalCacheManager localCacheManager, LoadBalancerClient loadBalancer) {
        super(localCacheManager);
        this.loadBalancer = loadBalancer;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        if (Objects.isNull(rule)) {
            return Mono.empty();
        }
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        SpringCloudRuleHandle ruleHandle = (SpringCloudRuleHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), SpringCloudRuleHandle.class);
        String serviceId = selector.getHandle();
        if (StringUtils.isBlank((String)serviceId) || StringUtils.isBlank((String)ruleHandle.getPath())) {
            Object error = SoulResultWarp.error(SoulResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID.getCode(), SoulResultEnum.CANNOT_CONFIG_SPRINGCLOUD_SERVICEID.getMsg(), null);
            return SoulResultUtils.result(exchange, error);
        }
        ServiceInstance serviceInstance = this.loadBalancer.choose(serviceId);
        if (Objects.isNull(serviceInstance)) {
            Object error = SoulResultWarp.error(SoulResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR.getCode(), SoulResultEnum.SPRINGCLOUD_SERVICEID_IS_ERROR.getMsg(), null);
            return SoulResultUtils.result(exchange, error);
        }
        URI uri = this.loadBalancer.reconstructURI(serviceInstance, URI.create(requestDTO.getRealUrl()));
        String realURL = this.buildRealURL(uri.toASCIIString(), requestDTO.getHttpMethod(), exchange.getRequest().getURI().getQuery());
        exchange.getAttributes().put("httpUrl", realURL);
        exchange.getAttributes().put("httpTimeOut", ruleHandle.getTimeout());
        return chain.execute(exchange);
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.SPRING_CLOUD.getCode();
    }

    @Override
    public String named() {
        return PluginEnum.SPRING_CLOUD.getName();
    }

    @Override
    public Boolean skip(ServerWebExchange exchange) {
        RequestDTO body = (RequestDTO)exchange.getAttribute("requestDTO");
        return !Objects.equals(Objects.requireNonNull(body).getRpcType(), RpcTypeEnum.SPRING_CLOUD.getName());
    }

    private String buildRealURL(String url, String httpMethod, String query) {
        if (httpMethod.equals(HttpMethod.GET.name()) && StringUtils.isNotBlank((String)query)) {
            return url + "?" + query;
        }
        return url;
    }
}

