/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.hystrix;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.dto.convert.HystrixHandle;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.common.utils.GsonUtils;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.plugin.hystrix.HystrixBuilder;
import org.dromara.soul.web.plugin.hystrix.HystrixCommand;
import org.dromara.soul.web.request.RequestDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import rx.Subscription;

public class HystrixPlugin
extends AbstractSoulPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(HystrixPlugin.class);

    public HystrixPlugin(LocalCacheManager localCacheManager) {
        super(localCacheManager);
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        assert (requestDTO != null);
        HystrixHandle hystrixHandle = (HystrixHandle)GsonUtils.getInstance().fromJson(rule.getHandle(), HystrixHandle.class);
        if (StringUtils.isBlank((CharSequence)hystrixHandle.getGroupKey())) {
            hystrixHandle.setGroupKey(Objects.requireNonNull(requestDTO).getModule());
        }
        if (StringUtils.isBlank((CharSequence)hystrixHandle.getCommandKey())) {
            hystrixHandle.setCommandKey(Objects.requireNonNull(requestDTO).getMethod());
        }
        HystrixCommand command = new HystrixCommand(HystrixBuilder.build(hystrixHandle), exchange, chain);
        return Mono.create(s -> {
            Subscription sub = command.toObservable().subscribe(arg_0 -> ((MonoSink)s).success(arg_0), arg_0 -> ((MonoSink)s).error(arg_0), () -> ((MonoSink)s).success());
            s.onCancel(() -> ((Subscription)sub).unsubscribe());
            if (command.isCircuitBreakerOpen()) {
                LOGGER.error("hystrix execute have circuitBreaker is Open! groupKey:{},commandKey:{}", (Object)hystrixHandle.getGroupKey(), (Object)hystrixHandle.getCommandKey());
            }
        }).doOnError(throwable -> {
            LOGGER.error("hystrix execute exception:", throwable);
            exchange.getAttributes().put("webHandlerClientResponseResultType", ResultEnum.ERROR.getName());
            chain.execute(exchange);
        }).then();
    }

    @Override
    public String named() {
        return PluginEnum.HYSTRIX.getName();
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.FUNCTION;
    }

    @Override
    public int getOrder() {
        return PluginEnum.HYSTRIX.getCode();
    }
}

