/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.soul.web.plugin.montior;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dromara.soul.common.dto.RuleData;
import org.dromara.soul.common.dto.SelectorData;
import org.dromara.soul.common.enums.PluginEnum;
import org.dromara.soul.common.enums.PluginTypeEnum;
import org.dromara.soul.common.enums.ResultEnum;
import org.dromara.soul.web.cache.LocalCacheManager;
import org.dromara.soul.web.disruptor.publisher.SoulEventPublisher;
import org.dromara.soul.web.influxdb.entity.MonitorDO;
import org.dromara.soul.web.plugin.AbstractSoulPlugin;
import org.dromara.soul.web.plugin.SoulPluginChain;
import org.dromara.soul.web.request.RequestDTO;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class MonitorPlugin
extends AbstractSoulPlugin {
    private final SoulEventPublisher soulEventPublisher;

    public MonitorPlugin(SoulEventPublisher soulEventPublisher, LocalCacheManager localCacheManager) {
        super(localCacheManager);
        this.soulEventPublisher = soulEventPublisher;
    }

    @Override
    protected Mono<Void> doExecute(ServerWebExchange exchange, SoulPluginChain chain, SelectorData selector, RuleData rule) {
        Optional.ofNullable(this.buildMonitorData(exchange)).ifPresent(this.soulEventPublisher::publishEvent);
        return chain.execute(exchange);
    }

    @Override
    public String named() {
        return PluginEnum.MONITOR.getName();
    }

    @Override
    public int getOrder() {
        return PluginEnum.MONITOR.getCode();
    }

    private MonitorDO buildMonitorData(ServerWebExchange exchange) {
        RequestDTO requestDTO = (RequestDTO)exchange.getAttribute("requestDTO");
        if (Objects.isNull(requestDTO) || Objects.isNull(exchange.getRequest().getRemoteAddress())) {
            return null;
        }
        String resultType = (String)exchange.getAttribute("webHandlerClientResponseResultType");
        if (StringUtils.isBlank((CharSequence)resultType)) {
            resultType = ResultEnum.ERROR.getName();
        }
        return MonitorDO.builder().resultType(resultType).rpcType(requestDTO.getRpcType()).count(1).module(requestDTO.getModule()).method(requestDTO.getMethod()).ip(exchange.getRequest().getRemoteAddress().getAddress().getHostAddress()).host(exchange.getRequest().getRemoteAddress().getHostString()).elapsedTime(Duration.between(LocalDateTime.now(), requestDTO.getStartDateTime()).toMillis()).build();
    }

    @Override
    public PluginTypeEnum pluginType() {
        return PluginTypeEnum.LAST;
    }
}

