/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.bean;

import java.util.Objects;
import org.dromara.stream.core.optional.Opp;

public class BeanHelper {
    public static final String GETTER_PREFIX = "get";
    public static final String GETTER_BOOLEAN_PREFIX = "is";
    public static final String SETTER_PREFIX = "set";

    private BeanHelper() {
    }

    public static String getPropertyName(String getterOrSetter) {
        String originProperty = null;
        if (BeanHelper.isGetterBoolean(getterOrSetter)) {
            originProperty = getterOrSetter.replaceFirst(GETTER_BOOLEAN_PREFIX, "");
        } else if (BeanHelper.isGetter(getterOrSetter)) {
            originProperty = getterOrSetter.replaceFirst(GETTER_PREFIX, "");
        } else if (BeanHelper.isSetter(getterOrSetter)) {
            originProperty = getterOrSetter.replaceFirst(SETTER_PREFIX, "");
        }
        if (Objects.isNull(originProperty)) {
            throw new UnsupportedOperationException(getterOrSetter + " is not getter or setter");
        }
        return originProperty.substring(0, 1).toLowerCase() + originProperty.substring(1);
    }

    public static boolean isGetter(String methodName) {
        return Opp.ofStr(methodName).is(s -> s.startsWith(GETTER_PREFIX) || s.startsWith(GETTER_BOOLEAN_PREFIX));
    }

    public static boolean isGetterBoolean(String methodName) {
        return Opp.ofStr(methodName).is(s -> s.startsWith(GETTER_BOOLEAN_PREFIX));
    }

    public static boolean isSetter(String methodName) {
        return Opp.ofStr(methodName).is(s -> s.startsWith(SETTER_PREFIX));
    }

    public static String getSetterName(String propertyName) {
        return SETTER_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }

    public static String getGetterName(String propertyName) {
        return GETTER_PREFIX + propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }
}

