/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.business.highlight;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.dromara.stream.core.business.highlight.FoundWord;
import org.dromara.stream.core.optional.Opp;
import org.dromara.stream.core.stream.Steam;

public class HighlightHelper {
    private HighlightHelper() {
    }

    public static String highlight(String text, List<FoundWord> fondWords, UnaryOperator<String> highlightOperator) {
        if (Opp.ofColl(fondWords).isEmpty() || Opp.ofStr(text).isEmpty()) {
            return text;
        }
        fondWords = ((Steam)Steam.of(fondWords).sorted(Comparator.comparing(FoundWord::getIndex).thenComparingInt(w -> w.getWord().length()))).toList();
        LinkedList<FoundWord> linkedList = new LinkedList<FoundWord>();
        int lastIdx = 0;
        for (int i = 0; i < fondWords.size(); ++i) {
            FoundWord fondWord = fondWords.get(i);
            String word = null;
            if (i > 0 && lastIdx > fondWord.getIndex()) {
                FoundWord last = (FoundWord)Objects.requireNonNull(linkedList.pollLast());
                lastIdx -= last.getWord().length();
                int index = fondWord.getWord().indexOf(last.getWord().charAt(last.getWord().length() - 1));
                String suffix = fondWord.getWord().substring(index + 1);
                word = last.getWord() + suffix;
            } else {
                String partOne = text.substring(lastIdx, fondWord.getIndex());
                linkedList.add(new FoundWord(partOne, lastIdx += partOne.length()));
            }
            word = Opp.ofStr(word).orElseGet(fondWord::getWord);
            linkedList.add(new FoundWord(word, (String)highlightOperator.apply(word), lastIdx += word.length()));
        }
        linkedList.add(new FoundWord(text.substring(lastIdx), text.substring(lastIdx), lastIdx));
        return Steam.of(linkedList).map(FoundWord::getWordAfterHighlight).join();
    }
}

