/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.business.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.dromara.stream.core.lambda.function.SerBiCons;
import org.dromara.stream.core.lambda.function.SerCons;
import org.dromara.stream.core.lambda.function.SerFunc;
import org.dromara.stream.core.lambda.function.SerPred;
import org.dromara.stream.core.optional.Opp;
import org.dromara.stream.core.stream.Steam;

public class TreeHelper<T, R extends Comparable<? super R>> {
    private final SerFunc<T, R> idGetter;
    private final SerFunc<T, R> pidGetter;
    private final R pidValue;
    private final SerPred<T> parentPredicate;
    private final SerFunc<T, List<T>> childrenGetter;
    private final SerBiCons<T, List<T>> childrenSetter;

    private TreeHelper(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, R pidValue, SerPred<T> parentPredicate, SerFunc<T, List<T>> childrenGetter, SerBiCons<T, List<T>> childrenSetter) {
        this.idGetter = idGetter;
        this.pidGetter = pidGetter;
        this.pidValue = pidValue;
        this.parentPredicate = parentPredicate;
        this.childrenGetter = childrenGetter;
        this.childrenSetter = childrenSetter;
    }

    public static <T, R extends Comparable<? super R>> TreeHelper<T, R> of(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, R pidValue, SerFunc<T, List<T>> childrenGetter, SerBiCons<T, List<T>> childrenSetter) {
        return new TreeHelper<T, R>(idGetter, pidGetter, pidValue, null, childrenGetter, childrenSetter);
    }

    public static <T, R extends Comparable<? super R>> TreeHelper<T, R> ofMatch(SerFunc<T, R> idGetter, SerFunc<T, R> pidGetter, SerPred<T> parentPredicate, SerFunc<T, List<T>> childrenGetter, SerBiCons<T, List<T>> childrenSetter) {
        return new TreeHelper<T, Object>(idGetter, pidGetter, null, parentPredicate, childrenGetter, childrenSetter);
    }

    public List<T> toTree(List<T> list) {
        if (Objects.isNull(this.parentPredicate)) {
            Map<R, List<T>> pIdValuesMap = ((Steam)Steam.of(list).filter(e -> Objects.nonNull(this.idGetter.apply(e)))).group(this.pidGetter);
            List parents = pIdValuesMap.getOrDefault(this.pidValue, new ArrayList());
            this.getChildrenFromMapByPidAndSet(pIdValuesMap);
            return parents;
        }
        ArrayList parents = new ArrayList(list.size());
        Map<R, List<T>> pIdValuesMap = ((Steam)Steam.of(list).filter(e -> {
            if (this.parentPredicate.test(e)) {
                parents.add(e);
            }
            return Objects.nonNull(this.idGetter.apply(e));
        })).group(this.pidGetter);
        this.getChildrenFromMapByPidAndSet(pIdValuesMap);
        return parents;
    }

    public List<T> flat(List<T> list) {
        AtomicReference<Function<Object, Steam>> recursiveRef = new AtomicReference<Function<Object, Steam>>();
        Function<Object, Steam> recursive = e -> Steam.of((Iterable)this.childrenGetter.apply(e)).flat((Function)recursiveRef.get()).unshift(e);
        recursiveRef.set(recursive);
        return ((Steam)Steam.of(list).flat(recursive).peek(e -> this.childrenSetter.accept(e, null))).toList();
    }

    public List<T> filter(List<T> list, SerPred<T> condition) {
        AtomicReference recursiveRef = new AtomicReference();
        SerPred[] serPredArray = new SerPred[2];
        serPredArray[0] = condition::test;
        serPredArray[1] = e -> Opp.ofColl((Collection)this.childrenGetter.apply(e)).map(children -> ((Steam)Steam.of(children).filter((Predicate)recursiveRef.get())).toList()).peek(children -> this.childrenSetter.accept(e, (List<Object>)children)).is(s -> !s.isEmpty());
        SerPred recursive = SerPred.multiOr(serPredArray);
        recursiveRef.set(recursive);
        return ((Steam)Steam.of(list).filter(recursive)).toList();
    }

    public List<T> forEach(List<T> list, SerCons<T> action) {
        AtomicReference recursiveRef = new AtomicReference();
        SerCons[] serConsArray = new SerCons[2];
        serConsArray[0] = action::accept;
        serConsArray[1] = e -> Opp.ofColl((Collection)this.childrenGetter.apply(e)).peek(children -> Steam.of(children).forEach((Consumer)recursiveRef.get()));
        SerCons recursive = SerCons.multi(serConsArray);
        recursiveRef.set(recursive);
        Steam.of(list).forEach((Consumer)recursive);
        return list;
    }

    private void getChildrenFromMapByPidAndSet(Map<R, List<T>> pIdValuesMap) {
        Steam.of(pIdValuesMap.values()).flat(Function.identity()).forEach(value -> {
            List children = (List)pIdValuesMap.get(this.idGetter.apply(value));
            if (children != null) {
                this.childrenSetter.accept(value, children);
            }
        });
    }
}

