/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Sets {
    private Sets() {
    }

    @SafeVarargs
    public static <T> Set<T> of(T ... values) {
        if (Objects.isNull(values) || values.length == 0) {
            return new HashSet();
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    public static <T> Set<T> ofColl(Collection<T> values) {
        if (Objects.isNull(values)) {
            return new HashSet();
        }
        return new HashSet<T>(values);
    }

    public static <T> Set<T> empty() {
        return Collections.emptySet();
    }
}

