/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.lambda;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import org.dromara.stream.core.bean.BeanHelper;
import org.dromara.stream.core.lambda.LambdaExecutable;
import org.dromara.stream.core.lambda.LambdaInvokeException;
import org.dromara.stream.core.lambda.function.SerFunc;
import org.dromara.stream.core.lambda.function.SerSupp;
import org.dromara.stream.core.optional.Opp;
import org.dromara.stream.core.reflect.ReflectHelper;
import org.dromara.stream.core.stream.Steam;

public class LambdaHelper {
    private static final WeakHashMap<String, LambdaExecutable> SERIALIZED_LAMBDA_EXECUTABLE_CACHE = new WeakHashMap();
    private static final WeakHashMap<Class<?>, WeakHashMap<Executable, Object>> LAMBDA_REVERT_CACHE = new WeakHashMap();

    private LambdaHelper() {
    }

    private static SerializedLambda serialize(Serializable lambda) {
        if (lambda instanceof SerializedLambda) {
            return (SerializedLambda)lambda;
        }
        Class<?> clazz = lambda.getClass();
        if (!clazz.isSynthetic()) {
            throw new IllegalArgumentException("Not a lambda expression: " + clazz.getName());
        }
        try {
            Method writeReplace = ReflectHelper.accessible(clazz.getDeclaredMethod("writeReplace", new Class[0]));
            Object maybeSerLambda = writeReplace.invoke((Object)lambda, new Object[0]);
            if (maybeSerLambda instanceof SerializedLambda) {
                return (SerializedLambda)maybeSerLambda;
            }
            throw new IllegalStateException("writeReplace result value is not java.lang.invoke.SerializedLambda");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <T extends Serializable> LambdaExecutable resolve(T lambda) {
        Objects.requireNonNull(lambda, "lambda can not be null");
        if (lambda instanceof Proxy) {
            return LambdaExecutable.initProxy((Proxy)lambda);
        }
        return SERIALIZED_LAMBDA_EXECUTABLE_CACHE.computeIfAbsent(lambda.getClass().getName(), key -> new LambdaExecutable(LambdaHelper.serialize(lambda)));
    }

    public static <T> T revert(Class<? super T> clazz, Executable executable) {
        WeakHashMap lambdaCache = LAMBDA_REVERT_CACHE.computeIfAbsent(clazz, key -> new WeakHashMap());
        return (T)lambdaCache.computeIfAbsent(executable, key -> {
            MethodType instantiatedMethodType;
            MethodHandle implMethod;
            Method funcMethod = Steam.of(clazz.getMethods()).findFirst(method -> Modifier.isAbstract(method.getModifiers())).orElseThrow(() -> new LambdaInvokeException("not a functional interface"));
            if (executable instanceof Method) {
                Method method2 = (Method)executable;
                implMethod = ((SerSupp<MethodHandle>)() -> MethodHandles.lookup().unreflect(method2)).get();
                instantiatedMethodType = MethodType.methodType(method2.getReturnType(), method2.getDeclaringClass(), method2.getParameterTypes());
            } else {
                Constructor constructor = (Constructor)executable;
                implMethod = ((SerSupp<MethodHandle>)() -> MethodHandles.lookup().unreflectConstructor(constructor)).get();
                instantiatedMethodType = MethodType.methodType(constructor.getDeclaringClass(), constructor.getParameterTypes());
            }
            CallSite callSite = ((SerSupp<CallSite>)() -> Serializable.class.isAssignableFrom(clazz) ? LambdaMetafactory.altMetafactory(MethodHandles.lookup(), funcMethod.getName(), MethodType.methodType(clazz), MethodType.methodType(funcMethod.getReturnType(), funcMethod.getParameterTypes()), implMethod, instantiatedMethodType, 1) : LambdaMetafactory.metafactory(MethodHandles.lookup(), funcMethod.getName(), MethodType.methodType(clazz), MethodType.methodType(funcMethod.getReturnType(), funcMethod.getParameterTypes()), implMethod, instantiatedMethodType)).get();
            MethodHandle target = callSite.getTarget();
            return ((SerSupp<Object>)() -> SerFunc.cast().apply(target.invoke())).get();
        });
    }

    @SafeVarargs
    public static <T> List<String> getPropertyNames(SerFunc<T, ?> ... funcs) {
        return Steam.of(funcs).map(LambdaHelper::getPropertyName).toList();
    }

    public static <T> String getPropertyName(SerFunc<T, ?> func) {
        return Opp.of(func).map(LambdaHelper::resolve).map(LambdaExecutable::getName).map(BeanHelper::getPropertyName).get();
    }
}

