/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.stream.core.lambda.function;

import java.io.Serializable;
import java.util.Objects;
import org.dromara.stream.core.lambda.LambdaInvokeException;

@FunctionalInterface
public interface SerArgsFunc<T, R>
extends Serializable {
    public static <T> SerArgsFunc<T, T> last() {
        return t -> t != null && t.length > 0 ? t[t.length - 1] : null;
    }

    public R applying(T ... var1) throws Throwable;

    default public R apply(T ... t) {
        try {
            return this.applying(t);
        }
        catch (Throwable e) {
            throw new LambdaInvokeException(e);
        }
    }

    default public <V> SerArgsFunc<V, R> compose(SerArgsFunc<? super V, ? extends T> before) {
        Objects.requireNonNull(before);
        return v -> this.apply(before.apply(v));
    }

    default public <V> SerArgsFunc<T, V> andThen(SerArgsFunc<? super R, ? extends V> after) {
        Objects.requireNonNull(after);
        return t -> after.apply(this.apply(t));
    }
}

